--	Package File Template
--
--	Purpose: This package defines supplemental types, subtypes, 
--		 constants, and functions 


library IEEE;
use IEEE.STD_LOGIC_1164.all;

package mpi_pkg is
-- Declare constants

--  constant <constant_name>		: time := <time_unit> ns;
  constant NPROC		: positive:= 8;

-- type declaration
type portio is array(1 to NPROC) of std_logic_vector (7 downto 0);  
--  type <new_type> is
--    record
--        <type_name>        : std_logic_vector( 7 downto 0);
--        <type_name>        : std_logic;
--    end record;


-- Declare signals for interconnections
 

   --Inputs
   signal noc_portOut :portio;
   signal noc_portIn  :portio;
	   
   signal noc_fifo_in_full :  std_logic_vector(NPROC downto 1):= (others => '0');
   signal noc_data_available :   std_logic_vector(NPROC downto 1):= (others => '0');
   signal noc_fifo_in_empty : std_logic_vector(NPROC downto 1):= (others => '0');
	signal noc_data_in_en : std_logic_vector(NPROC downto 1) := (others => '0');
   signal noc_data_out_en : std_logic_vector(NPROC downto 1) := (others => '0');
   signal noc_clk : std_logic := '0';
   signal noc_reset : std_logic := '0';
	
-- Declare components
COMPONENT SWITCH_GENERIQUE
	 GENERIC (number_of_ports : positive := 8);
    PORT(
         Port1_in : IN  std_logic_vector(7 downto 0);
         Port2_in : IN  std_logic_vector(7 downto 0);
         Port3_in : IN  std_logic_vector(7 downto 0);
         Port4_in : IN  std_logic_vector(7 downto 0);
         Port5_in : IN  std_logic_vector(7 downto 0);
         Port6_in : IN  std_logic_vector(7 downto 0);
         Port7_in : IN  std_logic_vector(7 downto 0);
         Port8_in : IN  std_logic_vector(7 downto 0);
         Port9_in : IN  std_logic_vector(7 downto 0);
         Port10_in : IN  std_logic_vector(7 downto 0);
         Port11_in : IN  std_logic_vector(7 downto 0);
         Port12_in : IN  std_logic_vector(7 downto 0);
         Port13_in : IN  std_logic_vector(7 downto 0);
         Port14_in : IN  std_logic_vector(7 downto 0);
         Port15_in : IN  std_logic_vector(7 downto 0);
         Port16_in : IN  std_logic_vector(7 downto 0);
         Port1_out : OUT  std_logic_vector(7 downto 0);
         Port2_out : OUT  std_logic_vector(7 downto 0);
         Port3_out : OUT  std_logic_vector(7 downto 0);
         Port4_out : OUT  std_logic_vector(7 downto 0);
         Port5_out : OUT  std_logic_vector(7 downto 0);
         Port6_out : OUT  std_logic_vector(7 downto 0);
         Port7_out : OUT  std_logic_vector(7 downto 0);
         Port8_out : OUT  std_logic_vector(7 downto 0);
         Port9_out : OUT  std_logic_vector(7 downto 0);
         Port10_out : OUT  std_logic_vector(7 downto 0);
         Port11_out : OUT  std_logic_vector(7 downto 0);
         Port12_out : OUT  std_logic_vector(7 downto 0);
         Port13_out : OUT  std_logic_vector(7 downto 0);
         Port14_out : OUT  std_logic_vector(7 downto 0);
         Port15_out : OUT  std_logic_vector(7 downto 0);
         Port16_out : OUT  std_logic_vector(7 downto 0);
         data_in_en : IN  std_logic_vector(8 downto 1);
         data_out_en : IN  std_logic_vector(8 downto 1);
         fifo_in_full : OUT  std_logic_vector(8 downto 1);
         fifo_in_empty : OUT  std_logic_vector(8 downto 1);
         data_available : OUT  std_logic_vector(8 downto 1);
         clk : IN  std_logic;
         reset : IN  std_logic
        );
    END COMPONENT;
	COMPONENT CORE_MPI is
    Port ( instruction : in  STD_LOGIC_VECTOR (7 downto 0);
           instruction_en : in  STD_LOGIC;
           ram_data_in : in  STD_LOGIC_VECTOR (7 downto 0);
           barrier_completed : out  STD_LOGIC;
           packet_received : out  STD_LOGIC;
			  packet_ack : in std_logic;
           PushOut : out  STD_LOGIC_VECTOR (7 downto 0);
           ram_we : out  STD_LOGIC;
           ram_address : out  STD_LOGIC_VECTOR (15 downto 0);
           ram_data_out : out  STD_LOGIC_VECTOR (7 downto 0);
           switch_port_in_wr_en : out  STD_LOGIC;   -- OK (au switch) pour lire les donnes 
           switch_port_in_full : in  STD_LOGIC;  -- port d'entrendu switch satur
           switch_port_in_data : out  STD_LOGIC_VECTOR (7 downto 0); -- port de dones d'entre
           switch_port_out_rd_en : out  STD_LOGIC;    -- OK (au switch) pour crire les donnes
           switch_port_out_data_vailaible : in  STD_LOGIC; -- Donne disponible  la sortie (du switch)
			  clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
           ram_en : out  STD_LOGIC;
           instruction_fifo_full : out  STD_LOGIC;
           switch_port_out_data : in  STD_LOGIC_VECTOR (7 downto 0));
	end COMPONENT;
-- declare functions and procedure	 
  
end MPI_PKG;


package body MPI_PKG is

-- Example 1
   


-- cette fonction met en place l'architecture d'excution de l'environnement
-- elle permet de construire le Noc et de connecter les diffrents core MPI
-- chaque core reoit un ID qui sera son Rank lors de l'appel  MPI_GET_Rank
-- faut il crer une petite mmoire charge de stocker les IDs ?
-- Oui car cette mmoire sera consulte par la fonction MPI_Init pour associer
-- un communicateur au MPI Core
  
   
end MPI_PKG;
