--	Package File Template
--
--	Purpose: This package defines supplemental types, subtypes, 
--		 constants, and functions
-- package definissant le codage des fonctions MPI 
-- dans le champs packet type des instructions MPI 

-- Ce fichier dfinit les trames des instruction MPI qui sont utilisables
library IEEE;
use IEEE.STD_LOGIC_1164.all;

package Packet_type is

 constant MPI_GET_RANK								: std_logic_vector(3 downto 0) := "0000";
 constant MPI_GET_SIZE								: std_logic_vector(3 downto 0) := "0001";
 constant MPI_BARRIER								: std_logic_vector(3 downto 0) := "0010";
 constant MPI_BARRIER_REACHED						: std_logic_vector(3 downto 0) := "0011";
 constant MPI_BARRIER_COMPLETED					: std_logic_vector(3 downto 0) := "0100";
 constant MPI_PUT   									: std_logic_vector(3 downto 0) := "0101";
 constant MPI_GET  									: std_logic_vector(3 downto 0) := "0110";
 constant MPI_BROADCAST								: std_logic_vector(3 downto 0) := "0111";
 constant MPI_INIT     								: std_logic_vector(3 downto 0) := "1000";
 constant MPI_SPWAN									: std_logic_vector(3 downto 0) := "1001";
 constant MPI_WTIME									: std_logic_vector(3 downto 0) := "1010";
 constant MPI_WTICK									: std_logic_vector(3 downto 0) := "1011";
 constant MPI_WINPOST								: std_logic_vector(3 downto 0) := "1100";
 constant MPI_CONFIG								   : std_logic_vector(3 downto 0) := "1101";
 --paramtres des commandes
 Constant INIT_ASKMAIN								: std_logic_vector(3 downto 0) := "0001";
 Constant INIT_SETRANK								: std_logic_vector(3 downto 0) := "0010";
 Constant INIT_REGISTER								: std_logic_vector(3 downto 0) := "0011";

end Packet_type;  

package body Packet_type is


end Packet_type;
