
----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    09:29:48 04/18/2011 
-- Design Name: 
-- Module Name:    OUTPUT_PORT_MODULE - Behavioral_description 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description:
-- cette version du module de sortie se limite  une instance du fifo ordinaire 
-- les donnes son emise en sortie  chaque cycle d'horloge
-- Dependencies: 
--
-- Revision: 07-08-2013
-- Revision 0.01 - File Created
-- Additional Comments: Ajout d'un dlai pour ignorer les paquets qui sont l depuis
-- longtemps
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
--use IEEE.STD_LOGIC_ARITH.ALL;
--use IEEE.STD_LOGIC_UNSIGNED.ALL;
USE ieee.numeric_std.ALL;
Library NocLib;
use NocLib.CoreTypes.all;
---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity OUTPUT_PORT_MODULE is
    Port ( data_in : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           reset : in  STD_LOGIC;
           clk : in  STD_LOGIC;
           wr_en : in  STD_LOGIC;
           data_out : out  STD_LOGIC_VECTOR (Word-1 downto 0);
			  fifo_full : out std_logic;
			  data_avalaible : out std_logic;
			  rd_out_en : in  STD_LOGIC);
end OUTPUT_PORT_MODULE;

architecture Behavioral_description of OUTPUT_PORT_MODULE is
-- declaration du FIFO 64 octets
component FIFO_256_FWFT
	port (
	clk: IN std_logic;
	din: IN std_logic_VECTOR(Word-1 downto 0);
	rd_en: IN std_logic;
	srst: IN std_logic;
	wr_en: IN std_logic;
	dout: out std_logic_VECTOR(Word-1 downto 0);
	empty: OUT std_logic;
	full: OUT std_logic);
end component;
--definition du type etat pour les fsm
type typ_outfsm is (Idle,waiting,dropping,reading);
type typ_receiv is (r_wait,r_head,r_len,r_glen,r_data,r_pulse,r_end);

signal EtRec : typ_receiv;
signal Et_out_fsm : typ_outfsm;
signal fifo_empty : std_logic;	
signal sw : std_logic:='0'; -- permet de positionner le mux sur les signaux internes
signal tlimit : natural:=0; --permet de compter les impulsions de temps
signal n : natural:=0; --utiliser pour la mae du tampon de sortie
signal rcv_start :  std_logic; --dbut de la rception
signal  rcv_ack : std_logic;   -- acquittement de la rception
signal  rcv_comp :  std_logic; -- fin de la rception
signal   spop,pop,rd_en,dat_avail :  std_logic:='0';
signal  mem,fifo_out :  std_logic_vector(Word-1 downto 0); --variable tampon sans intrt rel
begin
-- instantiation du FIFO_64
 OUTPUT_PORT_FIFO : FIFO_256_FWFT
		port map (
			clk => clk,
			din => data_in,
			rd_en => rd_en,
			srst => reset,
			wr_en => wr_en,
			dout => fifo_out,
			empty => fifo_empty,
			full => fifo_full);
			

outport_proc : process(clk,reset,fifo_empty)
begin
if rising_edge(clk) then
if reset='1' then
n<=0;
Et_out_fsm<=Idle;
else
case(Et_out_fsm) is 

when Idle => --idle
	if fifo_empty = '0' then
		Et_Out_fsm<=waiting;
	end if;
	tlimit<=0;
	sw<='0';
when reading =>
if rd_out_en='0' then
	Et_out_fsm<=Idle;
end if;
sw<='0';
when waiting =>  --counting
if rd_out_en='1' then
	Et_out_fsm<=reading;
elsif tlimit=350 then
	Et_out_fsm<=dropping;
	tlimit<=0;
else
	tlimit<=tlimit+1;
end if;
sw<='0';
when dropping => --dropping packet
	if n=0 then
		rcv_start<='1';
		n<=1;
		sw<='1';
	elsif n=1 then
		if rcv_comp='1' then
			rcv_ack<='1';
			rcv_start<='0';
			n<=2;
		end if;
		sw<='1';
	elsif n=2 then
		sw<='0';
		Et_out_fsm<=Idle;
		n<=0;
	end if;

end case;
end if;
end if;
end process outport_proc;
data_out<=fifo_out;
mux_proc : process (sw,rd_out_en,pop,fifo_empty)
begin
if sw='1' then --mode drop
	rd_en<=pop;
	data_avalaible <='0'; --plus de donnes dans le tampon !
else
	rd_en<=rd_out_en;
	data_avalaible <= not fifo_empty;
end if;
end process mux_proc;
proc_receiv : process (clk,reset)
variable dlen,i: natural range 0 to 255 :=0;

	begin
	if reset='1' then 
				 etrec<=r_wait;
				 
				else  
						if rising_edge(clk) then -- le process s'excute sur chaque front 
															-- montant de l'horloge
						case etrec is
						when r_wait  =>
							
							i:=0;
							if fifo_empty='0' and rcv_start='1' then
							
							etrec<=r_head;
							mem<=fifo_out;
							
							end if;
						when r_head  =>
							mem<=fifo_out;  --l'en-tte
							
							etrec<=r_len;
						when r_len =>
								dlen:=to_integer(unsigned(fifo_out));
								mem<=fifo_out; -- la longueur
								
								if dlen>2 then
									etrec<=r_data;
								else
									etrec<=r_end;
								end if;
								i:=1;
								
						when r_data  =>
								if fifo_empty='0' then
									if i<dlen-2 then
										i:=i+1;
										mem<=fifo_out;
										
										
									else
										etrec<=r_pulse;
										
										mem<=fifo_out;
									end if;
									-- time out  prvoir ici
								end if;
						when r_pulse =>
								etrec<=r_end;
								
						when r_end  =>
								if rcv_ack='1' then
									etrec<=r_wait;
								end if;
								
						when others =>
								
								
								etrec<=r_wait;
						end case;
						end if;
				end if;
	end process;
	
	pop<=spop;
	
rec_value : process (etrec)
begin
case etrec is
					when r_wait  =>
						spop<='0';
						rcv_comp<='0';
					when r_head  =>
							
							spop<='1';
							rcv_comp<='0';

					when r_len =>
							spop<='1';
					when r_data =>
							spop<='1';
					when r_pulse =>
								spop<='0';
								rcv_comp<='1';
					when r_end =>
							spop<='0';
							rcv_comp<='1';
					when others =>
							spop<='0';
							rcv_comp<='0';
				end case;
	end process;

end Behavioral_description;

