--------------------------------------------------------------------------------
-- Company: 
-- Engineer: GAMOM Roland Christian
--
-- Create Date:   16:44:13 08/01/2012
-- Design Name:   
-- Module Name:   C:/Core MPI/CORE_MPI/MultiMPITest.vhd
-- Project Name:  MPI_CORE_COMPONENTS
-- Target Device:  
-- Tool versions:  
-- Description:   
-- 
-- VHDL Test Bench Created by ISE for module: MPI_NOC
-- 
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- 
-- 
--------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
 
library NocLib ;

use NocLib.CoreTypes.all;
use work.Packet_type.all;

USE ieee.numeric_std.ALL;
 
ENTITY MultiMPITest IS
--simulation translate_off
port (clkm : in std_logic;
reset : in std_logic;
result : out std_logic_vector(Word-1 downto 0));
--simulation translate_on
END MultiMPITest;
 
ARCHITECTURE behavior OF MultiMPITest IS 
 
    -- Component Declaration for the Unit Under Test (UUT)
 
    COMPONENT MPI_NOC
	 generic (NPROC: natural:=2);
    PORT(
         MPI_Node_in : IN   Ar_MPIPort_in(1 to NPROC);
         MPI_Node_Out : OUT   Ar_MPIPort_out(1 to NPROC)
        );
    END COMPONENT;
  Component PE
  generic(destid : natural);
  Port ( Instruction : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Instruction_en : out  STD_LOGIC;
			  Core_PushOut : in STD_LOGIC_VECTOR (Word-1 downto 0);
           clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
			  CE : in  STD_LOGIC;
           Core_RAM_Data_Out : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Core_RAM_Data_In : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           Core_RAM_WE : in  STD_LOGIC;
           Core_RAM_EN : in  STD_LOGIC;
           --Core_RAM_ENB : in  STD_LOGIC;
           Core_RAM_ADDRESS_WR : in  STD_LOGIC_VECTOR (ADRLEN-1 downto 0);
           Core_RAM_ADDRESS_RD : in  STD_LOGIC_VECTOR (ADRLEN-1 downto 0);
           Core_Hold_req : in  STD_LOGIC;
           Core_Hold_Ack : out  STD_LOGIC);
end Component;  
 
 	constant clk_period : time := 10 ns;
   constant PROC : positive :=8;
-- synthesis translate_off
--===================signaux pour l'horloge ==============================
--signal reset,clkm : std_logic := '0';
--========================================================================
-- synthesis translate_on
 --signaux pour la gestion de la MAE
 type typ_mae is (start,Fillmem,NextFill,InitApp,InitCompleted,writeptr,InstrCopy, 
 putdata,putdata2,putcompleted,getdata,getdata2,getcompleted,terminate,st_timeout);
signal dcount : natural range 0 to 255:=0; --permet de compter le packet de donnes envoyes
signal count,count_i : natural range 0 to 15:=0;

signal MPI_Node_in : Ar_MPIPort_in(1 to PROC) ;
signal MPI_Node_Out : Ar_MPIPort_out(1 to PROC);



 
BEGIN
 Xbar: MPI_NOC GENERIC MAP (NPROC=>PROC)
		PORT MAP (
          MPI_Node_in => MPI_Node_in,
          MPI_Node_Out => MPI_Node_Out
        );

PE1: PE generic map (DestId=>0)
Port Map (
Instruction => MPi_Node_in(1).Instruction,
           Instruction_en => MPi_Node_in(1).Instruction_en,
			  Core_PushOut => MPi_Node_out(1).PushOut,
           clk =>clkm,
           reset =>reset,
			  CE => '1',
           Core_RAM_Data_Out =>MPi_Node_in(1).Ram_Data_out,
           Core_RAM_Data_IN => MPI_Node_out(1).ram_data_in,
           Core_RAM_WE => MPI_Node_out(1).ram_we,
           Core_RAM_EN => MPI_Node_out(1).ram_en,
          -- Core_RAM_ENB => MPI_Node_out(1).ram_en,
           Core_RAM_Address_Wr => MPI_Node_out(1).ram_address_wr,
           Core_RAM_Address_Rd => MPI_Node_out(1).ram_address_rd,
           Core_Hold_req => MPI_Node_out(1).hold_req,
           Core_Hold_Ack => MPI_Node_in(1).hold_ack
);

PE2: PE 	Generic map (DestId=>1)
			Port Map (
				Instruction => MPi_Node_in(2).Instruction,
           Instruction_en => MPi_Node_in(2).Instruction_en,
			  Core_PushOut => MPi_Node_out(2).PushOut,
           clk =>clkm,
           reset =>reset,
			  CE => '1',
           Core_RAM_Data_Out =>MPi_Node_in(2).Ram_Data_out,
           Core_RAM_Data_IN => MPI_Node_out(2).ram_data_in,
           Core_RAM_WE => MPI_Node_out(2).ram_we,
           Core_RAM_EN => MPI_Node_out(2).ram_en,
           --Core_RAM_ENB => MPI_Node_out(2).ram_en,
           Core_RAM_Address_Wr => MPI_Node_out(2).ram_address_wr,
           Core_RAM_Address_Rd => MPI_Node_out(2).ram_address_rd,
           Core_Hold_req => MPI_Node_out(2).hold_req,
           Core_Hold_Ack => MPI_Node_in(2).hold_ack
);
PE3: PE generic map (DestId=>2)
Port Map (
Instruction => MPi_Node_in(3).Instruction,
           Instruction_en => MPi_Node_in(3).Instruction_en,
			  Core_PushOut => MPi_Node_out(3).PushOut,
           clk =>clkm,
           reset =>reset,
			  CE => '1',
           Core_RAM_Data_Out =>MPi_Node_in(3).Ram_Data_out,
           Core_RAM_Data_IN => MPI_Node_out(3).ram_data_in,
           Core_RAM_WE => MPI_Node_out(3).ram_we,
           Core_RAM_EN => MPI_Node_out(3).ram_en,
          -- Core_RAM_ENB => MPI_Node_out(1).ram_en,
           Core_RAM_Address_Wr => MPI_Node_out(3).ram_address_wr,
           Core_RAM_Address_Rd => MPI_Node_out(3).ram_address_rd,
           Core_Hold_req => MPI_Node_out(3).hold_req,
           Core_Hold_Ack => MPI_Node_in(3).hold_ack
);

PE4: PE 	Generic map (DestId=>3)
			Port Map (
				Instruction => MPi_Node_in(4).Instruction,
           Instruction_en => MPi_Node_in(4).Instruction_en,
			  Core_PushOut => MPi_Node_out(4).PushOut,
           clk =>clkm,
           reset =>reset,
			  CE => '1',
           Core_RAM_Data_Out =>MPi_Node_in(4).Ram_Data_out,
           Core_RAM_Data_IN => MPI_Node_out(4).ram_data_in,
           Core_RAM_WE => MPI_Node_out(4).ram_we,
           Core_RAM_EN => MPI_Node_out(4).ram_en,
           --Core_RAM_ENB => MPI_Node_out(2).ram_en,
           Core_RAM_Address_Wr => MPI_Node_out(4).ram_address_wr,
           Core_RAM_Address_Rd => MPI_Node_out(4).ram_address_rd,
           Core_Hold_req => MPI_Node_out(4).hold_req,
           Core_Hold_Ack => MPI_Node_in(4).hold_ack
);
MPI_Node_in(1).reset<=reset;	
MPI_Node_in(1).clk<=clkm;
MPI_Node_in(2).reset<=reset;	
MPI_Node_in(2).clk<=clkm;
MPI_Node_in(3).reset<=reset;	
MPI_Node_in(3).clk<=clkm;
MPI_Node_in(4).reset<=reset;	
MPI_Node_in(4).clk<=clkm;
Result<=MPi_Node_out(1).PushOut;
PE_Dyn:for i in 5 to 6 generate
PE_i: PE 	Generic map (DestId=>i)
			Port Map (
				Instruction => MPi_Node_in(i).Instruction,
           Instruction_en => MPi_Node_in(i).Instruction_en,
			  Core_PushOut => MPi_Node_out(i).PushOut,
           clk =>clkm,
           reset =>reset,
			  CE => '0',
           Core_RAM_Data_Out =>MPi_Node_in(i).Ram_Data_out,
           Core_RAM_Data_IN => MPI_Node_out(i).ram_data_in,
           Core_RAM_WE => MPI_Node_out(i).ram_we,
           Core_RAM_EN => MPI_Node_out(i).ram_en,
           --Core_RAM_ENB => MPI_Node_out(2).ram_en,
           Core_RAM_Address_Wr => MPI_Node_out(i).ram_address_wr,
           Core_RAM_Address_Rd => MPI_Node_out(i).ram_address_rd,
           Core_Hold_req => MPI_Node_out(i).hold_req,
           Core_Hold_Ack => MPI_Node_in(i).hold_ack
);
MPI_Node_in(i).reset<=reset;	
MPI_Node_in(i).clk<=clkm;
end generate PE_Dyn;
END;
