----------------------------------------------------------------------------------
-- Company: 
-- Engineer: GAMOM Roland Christian
-- 
-- Create Date:    21:20:54 07/16/2012 
-- Design Name: 
-- Module Name:    PE - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: Ce module permet d'encapsuler une tche matrielle 
-- et lui donne la possiblit de communiquer  l'aide des fonctions MPI-2 RMA
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
library NocLib ;
library Std;
--use IEEE.STD_LOGIC_ARITH.ALL;
--use IEEE.STD_LOGIC_UNSIGNED.ALL;
use NocLib.CoreTypes.all;
use work.Packet_type.all;
use work.MPI_RMA.all;
-- synthesis translate_off 
use std.textio.all;
-- synthesis translate_on
use IEEE.NUMERIC_STD.ALL;


entity PE is
	Generic (DestId : natural:=0 );
    Port ( Instruction : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Instruction_en : out  STD_LOGIC;
			  Core_PushOut : in STD_LOGIC_VECTOR (Word-1 downto 0);
           clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
			  CE : in STD_LOGIC; -- Active le  PE aprs sa synthse
           Core_RAM_Data_Out : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Core_RAM_Data_In : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           Core_RAM_WE : in  STD_LOGIC;
           Core_RAM_EN : in  STD_LOGIC;
           --Core_RAM_ENB : in  STD_LOGIC;
           Core_RAM_ADDRESS_WR : in  STD_LOGIC_VECTOR (ADRLEN-1 downto 0);
           Core_RAM_ADDRESS_RD : in  STD_LOGIC_VECTOR (ADRLEN-1 downto 0);
           Core_Hold_req : in  STD_LOGIC;
           Core_Hold_Ack : out  STD_LOGIC);
end PE;

architecture Behavioral of PE is
COMPONENT RAM_v
  generic (width : positive;size :positive);
	PORT(
		clka : IN std_logic;
		clkb : IN std_logic;
		wea : IN std_logic;
		ena : IN std_logic;
		enb : IN std_logic;
		addra : IN std_logic_vector;
		addrb : IN std_logic_vector;
		dia : IN std_logic_vector;          
		dob : OUT std_logic_vector
		);
	END COMPONENT;
COMPONENT HT_process is
		generic (Task_Id : natural);
    Port ( clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
			  en : in std_logic; -- active la tche
           Interf_i : in  core_i; --signaux pour l'interface I
           Interf_o : out  core_o; --signaux pour l'interface IO
           mem_i : in typ_dpram_i; -- signaux pour l'accs  la mmoire
           mem_o : out typ_dpram_o -- signaux pour l'accs  la mmoire
			  );
end COMPONENT HT_process;
COMPONENT Hold_FSM is
	
    Port ( Hold_Req : in  STD_LOGIC;
           Ram_busy : in  STD_LOGIC;
           Clk : in  STD_LOGIC;
           Reset : in  STD_LOGIC;
           Ramsel : out  STD_LOGIC;
           Hold_Ack : out  STD_LOGIC);
end COMPONENT Hold_FSM;
--donnes du programme PE
	   --signaux pour l'interconnexionsignal datain :std_logic_vector(word-1 downto 0):= (others => '0');
	signal ram_we ,ram_ena,ram_enb,ramsel_i: std_logic:='0';
	signal pe_ram_we ,pe_ram_ena,pe_ram_enb: std_logic;
	signal pe_instr_en,pe_hold_ack: std_logic:='0';
	signal ram_do,ram_din:std_logic_vector(word-1 downto 0):= (others => '0');
	signal pe_ram_do,pe_ram_din:std_logic_vector(word-1 downto 0):= (others => '0');
	signal ram_addra,ram_addrb :std_logic_vector(ADRLEN-1 downto 0);
	signal pe_ram_addra,pe_ram_addrb :std_logic_vector(ADRLEN-1 downto 0);
	signal sram : typ_dpram;
	signal clk_ht : std_logic;
	signal MyGroup:mpi_group;
	signal MyWin : mpi_win;
	signal SrcAdr0,SrcAdr1,destAdr0,destAdr1,Datalen:std_logic_vector(word-1 downto 0);
	signal dpid,dpid_i : natural range 0 to 15:=DestId;
	signal MyRank :std_logic_vector(3 downto 0);
	signal Libr : Core_io;  --regroupe tous les signaux IO de la bibliothque
	signal Lib_Ready:std_logic; --indique que l'excution de la fonction est termine
	signal Lib_instr_ack : std_logic; -- l'instruction est copie dans le tampon FIFO
	signal Lib_Init : std_logic; -- l'initialisation est termine 
	signal Lib_Enable : std_logic;
	signal Hold_Ack : std_logic;
	signal en_task : std_logic;
 --signaux pour la gestion de la MAE
 type typ_mae is (start,Fillmem,NextFill,InitApp,GetRank,WInCreate,WinStart, putdata,getdata,WinCompleted,finalize,st_timeout);
	type typ_Hld is (Ht_Lock,Core_Lock,Ht_free);
signal dcount : natural range 0 to 255:=0; --permet de compter le packet de donnes envoyes
signal count,count_i : natural range 0 to 15:=0;


		signal RunState : typ_mae;
		signal Hld_state :typ_hld;
		signal Ram_busy :std_logic:='0';
begin
Inst_RAM_v: RAM_v generic map(width=>word,size=>ADRLEN)
	PORT MAP(
		clka =>clk ,
		clkb => clk ,
		wea => ram_we,
		ena => ram_ena,
		enb => ram_enb,
		addra => ram_addra,
		addrb =>ram_addrb,
		dia => ram_din,
		dob => ram_do 
	);
	HT_task:HT_process generic map(Task_id =>DestId)
	port map (
	clk=>clk_ht,
	reset=>reset,
	en=>en_task,
   Interf_i =>Libr.i,
   Interf_o=>Libr.o,
  mem_i =>sram.i,
   mem_o =>sram.o	);

--================================================================
	--MUX de la RAM
                             	
Ram_mux: process (clk,ramsel_i,pe_ram_addra,pe_ram_addrb,Core_ram_address_rd,Core_ram_address_wr,
						Core_ram_en,Core_ram_we,Core_ram_data_in,pe_ram_ena,pe_ram_enb,Ram_do,
						Pe_ram_din,Pe_ram_we	)
 begin 				
 case ramsel_i is
	
	when '1' =>
		ram_addra <= Core_ram_address_wr ;
		ram_addrb <= Core_ram_address_rd ;
		ram_ena <= Core_ram_en;
		ram_enb <= Core_ram_en;
		ram_we<= Core_ram_we;
		ram_din <= Core_ram_data_in;
		pe_ram_do<=(others=>'-');
		Core_ram_data_out<=ram_do;
		
	when others =>
		ram_addra <=  pe_ram_addra;
		ram_addrb <=  pe_ram_addrb;
		ram_ena <= pe_ram_ena;
		ram_enb <= pe_ram_enb;
		ram_we<= pe_ram_we;
		ram_din <=pe_ram_din;
		Core_ram_data_out<=(others=>'-');
		pe_ram_do<=ram_do;
end case ;
end process ;



Instruction_En<=PE_instr_EN; -- Libr.Instr_en; --********A changer **********
--=== !!!!! attention la suppression de la ligne ci-dessous empche ce 
-- composant de bien fonctionner !!! !!!!!!!!!!!!!!!!!!!!!!!
--instruction<=std_logic_vector(to_unsigned(Core_upper_adr,8));

dpid<=dpid_i;
en_task<= CE or Lib_enable; --l'activation d'une HT peut tre directe ou commande
Lib_Instr_ack<=Core_Pushout(0); --l'instruction a t copi
Lib_init<=Core_Pushout(4); -- Initialized
Lib_Enable<=Core_Pushout(6);-- HT active par la Librairie.

horloge_ht:process (reset,ce,lib_enable,clk)
begin
if reset='1' then
clk_ht<='0';
else
if ce='1' then
clk_ht<=clk;
elsif lib_enable='1' then
clk_ht<=clk;
else
clk_ht<='0';
end if;
end if;
end process horloge_ht;

Hold1: Hold_fsm port map (
clk=>clk ,
reset =>reset,
Ram_Busy=>Libr.O.membusy,
Hold_Ack=>Hold_Ack,
Hold_req =>Core_Hold_Req,
RamSel => RamSel_i);
Core_Hold_Ack<=Hold_Ack;

--================RAM signals ======================					
sram.I.data_out<=PE_ram_do;
pe_Ram_addra<=sram.O.addr_wr;
pe_Ram_addrb<=sram.O.addr_rd ; 
PE_Ram_we<=sram.O.we;
PE_Ram_ena<=sram.O.ena;
PE_Ram_enb<=sram.O.enb;
PE_ram_din<=sram.O.data_in;
--==========MPI HCL signals ============================

affect:process (clk,Core_hold_req,RamSel_i,Core_pushout,Libr)
begin
	--if (clk'event and clk='1') then 
Instruction<=Libr.O.Instruction;			
	Ram_busy<=Libr.O.membusy;
PE_Instr_EN<=Libr.O.instr_en;
Libr.I.Instr_ack<=Core_pushout(0);
Libr.I.InitOk<=Core_pushout(4);
Libr.I.Spawned<=Core_pushout(6);
Libr.I.Hold_Req<=Core_Hold_req;
--Libr.I.Hold_Ack<=Hold_Ack;
Libr.I.RamSel<=RamSel_i;		
--end if;
end process affect;
--=======================================================================
--MAE du PE
--=======================================================================

 
end Behavioral;

