----------------------------------------------------------------------------------
-- Company: 
-- Engineer:  GAMOM NGOUNOU
-- 
-- Create Date:    05:52:25 06/21/2011 
-- Design Name: 
-- Module Name:    CORE_MPI - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
Library NocLib;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use NocLib.CoreTypes.all;
---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity CORE_MPI is
    Port ( 
				clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
	         clkout : out std_logic;
				instruction : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           instruction_en : in  STD_LOGIC; --valide l'instruction
			  instruction_fifo_full : out  STD_LOGIC;
           ram_data_in : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           barrier_completed : out  STD_LOGIC;
           packet_received : out  STD_LOGIC;
			  packet_ack : in std_logic;
           PushOut : out  STD_LOGIC_VECTOR (Word-1 downto 0); --le resultat de l'excution
           ram_we : out  STD_LOGIC;
           ram_en : out  STD_LOGIC;
			  ram_address_rd : out  STD_LOGIC_VECTOR (15 downto 0);
			  ram_address_wr : out  STD_LOGIC_VECTOR (15 downto 0);
           ram_data_out : in  STD_LOGIC_VECTOR (Word-1 downto 0);
			  hold_req       : out STD_Logic;  --requete vers application
			  hold_ack       : in  STD_Logic;  --autorisation par l'application
           switch_port_in_cmd_en : out std_logic;
			  switch_port_out_data : in  STD_LOGIC_VECTOR (Word-1 downto 0);
			  switch_port_in_wr_en : out  STD_LOGIC;
           switch_port_in_full : in  STD_LOGIC;
           switch_port_in_data : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           switch_port_out_rd_en : out  STD_LOGIC;
           switch_port_in_empty : in STD_LOGIC;
			  switch_port_out_data_vailaible : in  STD_LOGIC
           );
           
end CORE_MPI;

architecture Structural of CORE_MPI is
--dclaration des types
type Type_Noc is
record
 port_in_cmd_en :  std_logic;
 port_out_data :   STD_LOGIC_VECTOR (Word-1 downto 0);
 port_in_wr_en :   STD_LOGIC;
 port_in_empty : STD_LOGIC;
 port_in_full :  STD_LOGIC;
 port_in_data :  STD_LOGIC_VECTOR (Word-1 downto 0);
 port_out_rd_en :  STD_LOGIC;
 port_out_data_available :  STD_LOGIC;
end record;
-- dclaration des composants MPI

COMPONENT FIFO_64_FWFT
	PORT(
		clk : IN std_logic;
		din : IN std_logic_vector(Word-1 downto 0);
		rd_en : IN std_logic;
		srst : IN std_logic;
		wr_en : IN std_logic;          
		dout : OUT std_logic_vector(Word-1 downto 0);
		empty : OUT std_logic;
		full : OUT std_logic
		);
END COMPONENT;
COMPONENT load_instr 
    Port ( Instruction : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           Instruction_en : in  STD_LOGIC;
           clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
           dma_rd_grant : in  STD_LOGIC;
           dma_rd_request : out  STD_LOGIC;
           instruction_ack : out  STD_LOGIC;
           fifo_din : out  STD_LOGIC_VECTOR (Word-1 downto 0);
			  fifo_wr :out std_logic;
           fifo_full : in  STD_LOGIC;
			  copying : out std_logic;
			  Ram_rd_en : out STD_LOGIC;
           ram_address_rd : buffer  STD_LOGIC_VECTOR (ADRLEN-1 downto 0);
           ram_data : in  STD_LOGIC_VECTOR (WORD-1 downto 0));
end component;
COMPONENT DMA_ARBITER
	PORT(
		
		clk : IN std_logic;
		reset : IN std_logic;
		dma_rd_request : IN std_logic_vector(3 downto 0);
		data_wr_in : IN std_logic_vector(Word-1 downto 0);
		data_rd_out : out std_logic_vector(Word-1 downto 0);
		address_rd : IN std_logic_vector(15 downto 0);
		address_wr : IN std_logic_vector(15 downto 0);
		
		dma_wr_request : IN std_logic_vector(3 downto 0);          
		address_out_rd : OUT std_logic_vector(15 downto 0);
		address_out_wr : OUT std_logic_vector(15 downto 0);
		ram_en : OUT std_logic;
		ram_we : OUT std_logic;
		hold_req       : out STD_Logic;  --requete vers application
		hold_ack       : in  STD_Logic;  --autorisation par l'application
		data_wr_mem  : OUT std_logic_vector(Word-1 downto 0); 
		data_rd_mem  : IN std_logic_vector(Word-1 downto 0);
		dma_wr_grant : OUT std_logic_vector(3 downto 0);
		dma_rd_grant : OUT std_logic_vector(3 downto 0)
		);
END COMPONENT;

COMPONENT EX1_FSM
	PORT(
		clk : IN std_logic;
		reset : IN std_logic;
		
		pid : in std_logic_vector (3 downto 0); --port id
		nprocs : in std_logic_vector (3 downto 0); -- la taille du Noc
    instruction : in std_logic_vector(Word-1 downto 0); 
		instruction_en : in std_logic;
		fifo_empty : IN std_logic;
		fifo_data_out : IN std_logic_vector(Word-1 downto 0);
		fifo_rd_en : OUT std_logic;
		fifo_src : IN STD_LOGIC;
		ram_data_in : IN std_logic_vector(Word-1 downto 0);
		ram_data_out : out std_logic_vector(Word-1 downto 0);
		dma_rd_grant : IN std_logic;   
		dma_wr_grant : IN std_logic;   		
		dma_wr_request : OUT std_logic;
		dma_rd_request : OUT std_logic;
		ram_address : OUT std_logic_vector(15 downto 0);
		ram_rd,ram_wr : out std_logic;
		Snd_Data : IN Typ_PortIO(0 to 3);
		Snd_Start : IN std_logic;
		Snd_Ack : OUT std_logic;		
		priority_rotation : OUT std_logic;
		
		switch_port_in_data : OUT std_logic_vector(Word-1 downto 0);
		switch_port_in_wr_en : OUT std_logic;
		switch_port_in_full : IN std_logic;
		Result :out std_logic_vector(Word-1 downto 0);
		Ready : out std_logic;
		AppInitReq :out  STD_LOGIC; -- requte d'initialisation de l'application
		AppInitAck :in  STD_LOGIC; -- Acquitement d'initialisation
		Initialized:in   std_logic  -- tat de la Lib
		);
	END COMPONENT;	
	
COMPONENT EX2_FSM
	PORT(
		clk : IN std_logic;
		reset : IN std_logic;
		
		instruction_en: in std_logic;
		Initialized : in std_logic;
		
		switch_port_out_rd_en : OUT std_logic ;
		switch_data_available : IN std_logic;
		switch_port_out_data : IN std_logic_vector(Word-1 downto 0);
		AppRank : in  STD_LOGIC_VECTOR;
      AppSize : in  STD_LOGIC_VECTOR;		  
		dma_wr_grant : IN std_logic;
		dma_wr_request : OUT std_logic;
		dma_rd_grant : IN std_logic;
		dma_rd_request : OUT std_logic;
		ram_address : OUT std_logic_vector(15 downto 0);
		ram_rd,ram_wr : out std_logic;
		Ram_data_out : in STD_LOGIC_VECTOR (Word-1 downto 0);
		Ram_data_in : out STD_LOGIC_VECTOR (Word-1 downto 0);
		fifo_full : IN std_logic;
		 Rec_Rdy : OUT std_logic;
		 Rec_Data : buffer Typ_PortIO(0 to 3);
		 Rec_Ack : IN std_logic;
		fifo_data : OUT std_logic_vector(Word-1 downto 0);
		fifo_wr_en : OUT std_logic;
		--fifo_out : out std_logic_vector;
		Result : out STD_LOGIC_VECTOR (Word-1 downto 0);
		packet_received : OUT std_logic;
		packet_ack : IN std_logic;
		barrier_completed : OUT std_logic;
		Ready : Out std_logic;
		AppInitAck : in std_logic;
		AppInitReq : out std_logic
		);
	END COMPONENT;


	COMPONENT EX3_FSM
	PORT(
		instruction : IN std_logic_vector(Word-1 downto 0);
		clk : IN std_logic;
		reset : IN std_logic;     
		Ismain :in std_logic;
		ResOut : OUT std_logic_vector(Word-1 downto 0)
		
		);
	END COMPONENT;
	
	COMPONENT EX4_FSM
	PORT(
    		  Instruction : in  STD_LOGIC_VECTOR (Word-1 downto 0); --permet de lire le FIFO
           Instruction_En : in  STD_LOGIC;
           clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
           ResultOut : out  STD_LOGIC_VECTOR (Word-1 downto 0);
           Result_En : out  STD_LOGIC; 
           Ready : out  STD_LOGIC; 
           NocSize : out  STD_LOGIC_VECTOR;
           AppRank : out  STD_LOGIC_VECTOR;
           AppSize : out  STD_LOGIC_VECTOR;
           IsMain : out  STD_LOGIC;
           I_fifo_full :in STD_LOGIC;
		      Snd_Ack : IN std_logic;
		      Rec_Rdy : IN std_logic;
		      Rec_Data : IN Typ_PortIO(0 to 3);
		      Snd_data : OUT Typ_PortIO(0 to 3);
		      Snd_Start : buffer std_logic;
		      Rec_Ack : OUT std_logic; 
		      I_fifo_wr_en: out STD_LOGIC;
		      I_fifo_data_in :out STD_LOGIC_vector(Word-1 downto 0);
			  Initialized : out STD_LOGIC;
			  dma_wr_request : out std_logic;
			  dma_rd_request : out std_logic;
			  dma_wr_grant : in std_logic;
			  dma_rd_grant : in std_logic;
           Ram_address : out  STD_LOGIC_VECTOR (15 downto 0); --accs au stockage
           Ram_wr : out  STD_LOGIC; --activation de l'criture en RAM
           Ram_Data_in : out  STD_LOGIC_VECTOR (Word-1 downto 0);--donnes des ports
			  Ram_data_out : in STD_LOGIC_VECTOR (Word-1 downto 0);
			  AppAck : in  STD_LOGIC;
           AppReq : in  STD_LOGIC;
			  PortId : out  STD_LOGIC_VECTOR(3 downto 0);
			  port_in_cmd_en : out  STD_LOGIC;
			  port_in_wr_en : out  STD_LOGIC;
			  port_in_empty : in  STD_LOGIC;
           port_in_full : in  STD_LOGIC;
           port_in_data : out  STD_LOGIC_VECTOR (Word-1 downto 0);
			  port_out_data : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           port_out_rd_en : out  STD_LOGIC;
           port_out_data_available : in  STD_LOGIC);
	END COMPONENT;
	
	COMPONENT EX0_FSM
	PORT(	
			clk : in  STD_LOGIC;
         reset : in  STD_LOGIC;
	
			Initialized : in  STD_LOGIC;
         Instruction : in  STD_LOGIC_VECTOR (Word-1 downto 0);
			instruction_en: in STD_LOGIC;
         
         ClkRate : in  STD_LOGIC_VECTOR ;
			uTimeResult : out  STD_LOGIC_VECTOR; 
			TickResult : out STD_LOGIC_VECTOR
			  );
	END COMPONENT;


COMPONENT MPI_CORE_SCHEDULER
	PORT(
		clk : IN std_logic;
		reset : IN std_logic;
		priority_rotation : IN std_logic;
		instruction_fifo_empty : IN std_logic;
		instruction_fifo_rd_en : OUT std_logic;
		instruction_fifo_data : IN std_logic_vector(Word-1 downto 0);
		instruction_available : OUT std_logic;
		
		get_request_fifo_empty : IN std_logic;
		get_request_fifo_rd_en : OUT std_logic;
		get_request_fifo_data : IN std_logic_vector(Word-1 downto 0);
		
		fifo_rd_en : IN std_logic;          
		fifo_empty : OUT std_logic;
		fifo_selected : OUT std_logic;
		
		data_out : OUT std_logic_vector(Word-1 downto 0)
		
		
		);
	END COMPONENT;
	
-- declaration des signaux d'interconnexion entre les modules du coresignal fifo_sel: std_logic;  -- indique l'un des deux fifos d'instructions qui sont prts
signal fifo_instr : std_logic;  -- une instruction est prte dans les fifos d'instruction


signal scheduler_fifo_empty : std_logic;
signal scheduler_data_out : std_logic_vector(Word-1 downto 0);
signal dma_arbiter_data_rd_out : std_logic_vector(Word-1 downto 0);

signal scheduler_priority_rotation : std_logic;
signal scheduler_rd_en : std_logic;

signal dma_data_rd,dma_data_wr : std_logic_vector(Word-1 downto 0); -- bus  3 tats
signal dma_rd_address,dma_rd_address1,dma_rd_address2 : std_logic_vector(15 downto 0);  -- ces bus doivent tre grs en logique 3 tats!
signal dma_rd_address3 : std_logic_vector(15 downto 0);
signal dma_wr_address1,dma_wr_address3 : std_logic_vector(15 downto 0);
signal dma_wr_address2,dma_wr_address4 : std_logic_vector(15 downto 0);
signal dma_wr_address : std_logic_vector(15 downto 0);
signal switch_port_in_data_signal : std_logic_vector(Word-1 downto 0);
signal ram_data_out_signal : std_logic_vector(Word-1 downto 0);
signal weram,rdram,ram_wev,ram_env :std_logic:='0';

signal i_fifo2_signal : std_logic_vector(Word-1 downto 0);
signal Ex_EN : std_logic_vector(4 downto 1):=(others=>'0'); --active les sous MAE permettant de dcoder les instructions MPI
signal Res4_en:std_logic;--acquittement du rusltat du module n4
signal Ex4_en,Ex1_RDY,Ex2_RDY,EX3_RDY,EX4_RDY : std_logic:='0'; -- indique la fin de l'excution de la MAE
signal ex1_ram_rd,ex2_ram_rd,ex4_ram_rd ,Exi_ram_rd: std_logic:='0' ; -- validation lecture des donnes en RAM
signal ex1_ram_wr,ex2_ram_wr,ex4_ram_wr,Exi_ram_wr : std_logic :='0'; -- validation criture des donnes en RAM
signal Exi_busy : std_logic:='0';
signal Ex1_Result,Ex2_Result,Ex4_result : std_logic_vector(Word-1 downto 0);
signal Instr_in :  STD_LOGIC_VECTOR (Word-1 downto 0);
--================interface DMA avec les modules ======================================
signal dma_data_in,Dma_data_in1,dma_data_in2,dma_data_in4   : std_logic_vector(Word-1 downto 0);
signal dma_data_out : std_logic_vector(Word-1 downto 0);
signal dma_rd_request :std_logic_vector(4 downto 1):=(others=>'0');
signal dma_wr_request :std_logic_vector(4 downto 1):=(others=>'0');
signal dma_wr_grant,dma_rd_grant:std_logic_vector(4 downto 1);
--
--======================================================================================
--connexion au switch

signal Noc1,NOC2,NOC3 : Type_Noc; -- regroupement des signaux qui vont au Noc

--================================================================
--dclaration des signaux d'tat du Core
signal IsMain,SizeSet,RankSet,Initialized,AppReq,AppAck:std_logic;
signal InitReq,InitReq1,InitReq2   :std_logic:='0'; -- demande d'initialisation
signal InitAck,IAck,Ilatch : std_logic:='0';
signal MPISize,MyRank : std_logic_vector(3 downto 0);
signal LibState: std_logic_vector(Word-1 downto 0):=(others=>'0'); --ready,receiving,sending,spawning,rwaiting,swaiting,...
signal NocSize :std_logic_vector(3 downto 0):=(others=>'0');
Signal PortId : std_logic_vector(3 downto 0);
Signal uClkRate : std_logic_vector(Word-1 downto 0):="00011010"; --50 Mhz
signal uTimeCount :std_logic_vector(31 downto 0):=(others=>'0');
signal TickCount : std_logic_vector(31 downto 0):=(others=>'0');
signal RankSize: std_logic_vector(Word-1 downto 0):=(others=>'0');
--========================================================
--dclaration des signaux permettant d'activer le module
signal AdrSelect : std_logic_vector(ADRLEN-1 downto 0);
--========================================================
--signal PushOut_d,RankSize,TickUsOut:std_logic_vector; --rsultat de l'execution des commandes mpi
--========================================================
--connexion avec les FIFO instructions
signal fifo1_wr : std_logic;
signal fifo1_din : std_logic_vector (Word-1 downto 0);
signal fifo_sel : std_logic;   --permet d'arbitrer la priorit de lecture entre les deux fifos
signal i_fifo1_rd_en : std_logic;
signal fifo1_full : std_logic;
signal i_fifo1_empty : std_logic;
signal i_fifo1_data_out : std_logic_vector(Word-1 downto 0);
signal i_fifo2_rd_en : std_logic;
signal i_fifo2_data_out : std_logic_vector(Word-1 downto 0);
signal i_fifo2_data_in : std_logic_vector(Word-1 downto 0);
signal i_fifo2_wr_en : std_logic;
signal i_fifo2_empty : std_logic;
signal i_fifo2_full : std_logic;
signal Ex2_i_fifo2_data_in : std_logic_vector(Word-1 downto 0):=(others=>'0');
signal Ex2_i_fifo2_wr_en : std_logic:='0';
--signaux pour les donnes entre modules
signal Snd_Ack :std_logic;
signal 		Rec_Rdy : std_logic;
signal 		Rec_Data :  Typ_PortIO(0 to 3);
signal 		Snd_data :  Typ_PortIO(0 to 3);
signal 		Snd_Start :  std_logic;
signal 		Rec_Ack :  std_logic; 
--signal i_fifo2_empty : std_logic;
--signal i_fifo2_full : std_logic;
signal Ex4_i_fifo2_data_in : std_logic_vector(Word-1 downto 0):=(others=>'0');
signal Ex4_i_fifo2_wr_en : std_logic:='0';
--signal i_fifo2_empty : std_logic;
--signal i_fifo2_full : std_logic;
-- signaux pour la gestion des MAE
signal n,n_i :natural range 0 to 7:=0;
signal St_Ex1,St_Ex2,St_Ex4:natural range 0 to 7:=0;
signal Next_St_Ex1,Next_St_Ex2,Next_St_Ex4:natural range 0 to 7:=0;
--===========================================================

begin
--switch_port_in_data_signal <= ;
--switch_port_out_data_signal <= ;
-- istanciation des composants du core MPI
Instruction_Fifo1: FIFO_64_FWFT PORT MAP(
		clk =>clk,
		din =>fifo1_din,
		rd_en => i_fifo1_rd_en,
		srst => reset,
		wr_en => fifo1_wr,
		dout =>i_fifo1_data_out,
		empty => i_fifo1_empty,
		full => fifo1_full
	);

Instruction_Fifo2: FIFO_64_FWFT PORT MAP(
		clk =>clk,
		din => i_fifo2_data_in ,
		rd_en =>i_fifo2_rd_en,
		srst =>reset,
		wr_en =>i_fifo2_wr_en,
		dout =>i_fifo2_data_out,
		empty =>i_fifo2_empty,
		full => i_fifo2_full 
	);
LD_instr:load_instr PORT MAP (

			  Instruction =>Instruction,
           Instruction_en =>Instruction_en,
           clk =>clk,
           reset =>reset,
           dma_rd_grant =>dma_rd_grant(3),
           dma_rd_request =>dma_rd_request(3), 
			  copying=> Exi_busy,
           instruction_ack =>iack,    --indique la fin de la copie d'une instruction dans le FIFO
           fifo_din => fifo1_din,
			  fifo_wr =>  fifo1_wr,
           fifo_full =>fifo1_full,
			  Ram_rd_en=> Exi_ram_rd,
           ram_address_rd => dma_rd_address3,
           ram_data =>dma_data_out    --sortie DMA
);

pushout(0)<=ILatch;
pushout(1)<=IsMain;
pushout(2)<=SizeSet;
pushout(3)<=Ex4_result(6); --Spawn in progress on main
pushout(4)<=Initialized;
pushout(5)<=Ex1_result(1); --
pushout(6)<=LibState(3); --Spawned child
pushout(7)<=Ex4_result(7); --Spawn complete
MPI_CORE_EX0_FSM: EX0_FSM PORT MAP(
		instruction => i_fifo1_data_out,
		instruction_en=> '1',
		uTimeResult => uTimeCount,
		TickResult => TickCount,
		Initialized => Initialized,  -- indique si la l'appel  init a t concluant
		ClkRate => uClkRate,
		clk =>clk ,
		reset => reset 
	);
MPI_CORE_EX1_FSM: EX1_FSM PORT MAP(
		clk =>clk ,
		reset =>reset,
		pid => MyRank,  --port Id
		nprocs=>MPISize,      --  revoir dans certains cas ou tous les PEs ne sont pas connects
		fifo_empty => scheduler_fifo_empty ,
		fifo_data_out =>scheduler_data_out,
		fifo_rd_en =>scheduler_rd_en,
		fifo_src =>fifo_sel,
		priority_rotation => scheduler_priority_rotation,
		
		instruction_en=>Ex_en(1),  			 --active le module
		Instruction => Instruction,
		switch_port_in_full =>Noc1.port_in_full, --ces signaux doivent tre contrls en 3 state logic
		switch_port_in_data =>Noc1.port_in_data,
		switch_port_in_wr_en =>Noc1.Port_in_wr_en ,
		
		Snd_Data =>Snd_Data,
		Snd_Start =>Snd_start,
		Snd_Ack =>Snd_ack,				          
		Ram_rd => ex1_ram_rd,
		Ram_wr =>ex1_ram_wr,
		ram_data_in =>dma_data_out,
		Ram_data_out =>dma_data_in1,
		ram_address=>dma_wr_address1,
		--ram_address =>dma_rd_address2,  --la mme adresse sert pour la lecture ou l'criture
		dma_rd_request =>dma_rd_request(1),
		dma_wr_request =>dma_wr_request(1),
		dma_rd_grant =>dma_rd_grant(1) ,
		dma_wr_grant =>dma_wr_grant(1) ,
		
		AppInitReq => InitReq1, -- requte d'initialisation de l'application
		AppInitAck =>Res4_En  , -- Acquitement d'initialisation
		Initialized=>Initialized,  -- tat de la Lib
		Result => Ex1_Result,     -- le rsultat de l'excution
		Ready=> Ex1_Rdy
	);
instruction_fifo_full<=fifo1_full;
dma_rd_address1<=dma_wr_address1;  --la mme adresse sert pour la lecture ou l'criture en RAM
Exi_sync :process(reset,clk)

begin
  if rising_edge(clk) then
    if reset='1' then
     St_Ex2<=0;
    St_Ex1<=0;
    St_Ex4<=0; 
    Ilatch<='0';
    n<=0;
  else
    St_Ex2<=Next_St_Ex2;
    St_Ex1<=Next_St_Ex1;
    St_Ex4<=Next_St_Ex4;
    ILatch<=Iack;
    n<=n_i;
  end if;
end if;
End process Exi_sync;
-- dtermination de l'activation des module
--scheduler_priority_rotation<=not(Ex1_rdy);
Ex1_Act:process(ST_Ex1,Initialized,fifo_instr,n,InitReq,Ex4_rdy,Ex1_rdy,Ex2_rdy)--A qoui sert encore ce processus (26/10/12) ????
variable c_cyl:natural range 0 to 15:=0;
begin
  if reset='1' then
      Next_St_ex1<=0;
      c_cyl:=0;
else -- cette machie  tat permet de distinguer les activations de Ex4 et Ex1
  case St_ex1 is
  when 0 => if InitReq='1' and Initialized='0' then
                Next_St_ex1<=1;
         elsif Initialized='1' then 
            Next_St_ex1 <=2;
        elsif fifo_instr='1' then --cas d'une instruction directe qui est prsente
            --if fifo_sel='0' then
                      Next_St_ex1 <=2;
            --end if;
        end if;
         
  when 1 => if Ex4_Rdy='1' then
                Next_St_ex1<=4;
        end if;
  when 2 => if Ex1_rdy='0' then  --ex1 est libre et actif
                      Next_St_ex1<=3;
               end if;
    
  when 3 => if Ex1_rdy='1'  and Initialized='0'then --ex1 est occup et actif
                Next_St_ex1<=0;
            elsif Ex1_rdy='1'  and Initialized='1' then
                Next_St_ex1<=2;
            end if;
             
  when 4 => if Ex2_rdy='0' then --s'il y a un message du rseau
            --compter quelques cycles d'horloges pour attendre initreq2
            if n=4 then
                  Next_St_ex1<=0;
              n_i<=0;
            else
              n_i<=n+1;
            end if;
          else
            Next_St_ex1<=0;
          end if;
    
  when others =>    
              Next_St_ex1<=0;
  end case;
end if;
end process ex1_Act;

ex1_v:process(St_Ex1)
  begin
    case St_Ex1 is 
  when 0 =>
                  Ex_en(1)<='0';
  when 1 =>
                  Ex_en(1)<='0';
  when 2|3 =>
             Ex_en(1)<='1';
  when others =>
            Ex_en(1)<='0';
  end case;
  
end process ex1_v;

Ex2_nextState:Process(reset,st_Ex2, Ex4_rdy,Initialized,Ex2_Result,Ex2_rdy) --active la rception lorsqu' Put ou un Get ou un Init a t effectu
begin
Next_St_Ex2<=st_Ex2;
Case st_Ex2 is

when 0 =>    
	if Initialized='1' and Ex4_rdy='1' then --- Ex1_result(0)='1' or Ex1_result(1)='1' or Ex1_result(2)='1' then
		  Next_St_Ex2<=1; --active la rception des mesages sur le noeud.
		
	else
	    Next_St_Ex2<=0;
	end if;
When 1 =>
    if Ex2_rdy='0' then
      Next_St_Ex2<=2;
  end if;
When 2 =>
    if Ex2_rdy='1' then
      Next_St_Ex2<=0;
  end if;
when others =>
	 Next_St_Ex2<=0;
	end case;
end process;
Ex2_val:Process(st_Ex2,Ex4_result) --

begin  
Case st_Ex2 is

when 0 =>    						
Ex_en(2)<='0';
--LibState(3)<='0';
when 1|2 =>
  Ex_en(2) <='1';
when 3|4|5|6|7 =>
  Ex_en(2)<='0';
when others=>
  Ex_en(2)<='0';
end case;
	if rising_edge(Ex4_result(1)) then
		LibState(3)<='1'; --spawn a t dtect.
	end if;			
end process;

Ex_en_proc:process (clk,reset)
begin
				if rising_edge(clk) then
				 if reset='1' then
					   Ex4_en<='0';
				 else
					
						if Ex_en(4)='1'  then
						  		Ex4_en<='1'; --synchro
						else
						    Ex4_en<='0'; --synchro
						end if;
					end if;
				end if;		  
end process;
Ex4_Active:process (St_Ex4,initreq1,initreq2,Ex1_rdy,Initialized,Res4_en)
begin
				
case St_Ex4 is
		when		0 => 
						if (InitReq1='1') then
						    Next_St_Ex4<=1;
						 elsif InitReq2='1'  then --le module 1 n'est pas actif
						    Next_St_Ex4<=2;
						 else
						    Next_St_Ex4<=0;
						end if;
			when 1 =>
						If Res4_en='1'  then --fin de l'excution du module
							Next_St_Ex4<=3;
						end if;
			when 2 =>
						if Res4_en='1'  then --Ex2_result(0)='1'
							Next_St_Ex4<=4;
						end if;
			when 3 =>
					  if initreq1='0' then
  						  Next_St_Ex4<=5;
						end if;
			when 4 =>
					  if initreq2='0' then
  						  Next_St_Ex4<=5;
						end if;
			when 5 =>
						Next_St_Ex4<=0;
			when others =>
      			  Next_St_Ex4<=0;
			end case;
					
end process Ex4_active;

Ex4_active_val:process (st_Ex4)
begin
 case St_Ex4 is
	when 0 =>
		AppReq<='0';
		InitReq<='0';Ex_en(4)<='0';
		AppAck<='0';
	when 1 =>
		AppReq<='1';
		InitReq<='1'; 
		Ex_en(4)<='1';
		AppAck<='0';
	when 2 =>
		AppReq<='1';
		InitReq<='1';
		Ex_en(4)<='1';
		AppAck<='0';
	when 3 =>
		AppReq<='0';
		InitReq<='0';
		Ex_en(4)<='0';
		AppAck<='1';
	when 4 =>
		AppReq<='0';
		InitReq<='0';
		Ex_en(4)<='0';
		AppAck<='1';
	when 5 =>
		AppReq<='0';
		InitReq<='0';Ex_en(4)<='0';
		AppAck<='1';
	when others =>
	  AppReq<='0';
		InitReq<='0';
		AppAck<='0';
		Ex_en(4)<='0';
 end case ;
-- Appreq<=Ex_en(4);  --signal d'activation de la MAE Init
--InitReq<=(not(Initialized) and InitReq1) or InitReq2; -- deux cas permettent d'activer l'initialisation
--AppAck<=Ex1_result(0) or Ex2_result(0); -- signal init completed
end process Ex4_active_val;
--Ex_en(2)<=Initialized; --- Me pose des soucis en ce moment ???
Ex_en(3)<='0';
--Ex_en(4)<= '1' when InitReq='1'  else '0';

-- soit une requte du PE soit une requte du Core


MPI_CORE_EX2_FSM: EX2_FSM PORT MAP(
		
		clk =>clk,
		reset =>reset,
		instruction_en=>Ex_en(2),
		Ready =>Ex2_rdy,      				--signale que le module est disponible
		fifo_full =>i_fifo2_full,
		
		fifo_wr_en => Ex2_i_fifo2_wr_en,
		fifo_data => Ex2_i_fifo2_data_in,
		
		switch_port_out_rd_en => Noc2.port_out_rd_en, 
		switch_data_available =>Noc2.port_out_data_available,
		switch_port_out_data =>Noc2.port_out_data ,
		
		 Rec_Rdy => Rec_Rdy,
		 Rec_Data =>Rec_Data,
		 Rec_Ack =>Rec_Ack,
													-- il manque un signal pour valider l'accs  la RAM
		dma_wr_request =>dma_wr_request(2),
		dma_wr_grant =>dma_wr_grant(2),
		dma_rd_request =>dma_rd_request(2),
		dma_rd_grant =>dma_rd_grant(2),
		ram_address =>dma_wr_address2,
		Ram_rd => ex2_ram_rd,
		Ram_wr =>ex2_ram_wr,
		Ram_data_out=> Dma_data_out,
		Ram_data_in => Dma_data_in2,
		packet_received =>packet_received,
		packet_ack => packet_ack,
		barrier_completed =>barrier_completed,
		AppRank =>MyRank,
      AppSize =>MPISize,
		AppInitReq => InitReq2, -- requte d'initialisation de l'application
		AppInitAck =>Res4_En  , -- Acquitement d'initialisation
		Initialized=>Initialized, 
		Result => Ex2_Result     -- le rsultat de l'excution
	);
Dma_rd_address2<=Dma_wr_address2;	
ICI_MPI_CORE_EX3_FSM: EX3_FSM PORT MAP(
		instruction => x"00", --pas utiliser
		ResOut => RankSize,
		clk =>clk ,
		IsMain=>IsMain,
		reset => reset 
	);
MPI_CORE_EX4_FSM :EX4_FSM PORT MAP (
			  Instruction => Instr_in,  --STD_LOGIC_VECTOR (Word-1 downto 0);
           Instruction_En =>Ex4_en,  -- ='1' lorsque ce module est sollicit
           clk  =>clk,
           reset =>reset,
           ResultOut =>Ex4_Result, --STD_LOGIC_VECTOR (Word-1 downto 0);
           Result_En =>Res4_En, -- ='1' lorsque fin de l'excution du module
           Ready => Ex4_Rdy,
           NocSize =>NocSize,
           AppRank =>MyRank,
           AppSize =>MPISize,
           IsMain =>IsMain,
            Rec_Rdy => Rec_Rdy,
		        Rec_Data =>Rec_Data,
		        Rec_Ack =>Rec_Ack,
            Snd_Ack =>Snd_ack,
		        Snd_data =>Snd_data,
		        Snd_Start =>Snd_Start,
		     
           I_fifo_full =>i_fifo2_full,
		
		      I_fifo_wr_en => Ex4_i_fifo2_wr_en,
		      I_fifo_data_in => Ex4_i_fifo2_data_in,
			  Initialized =>Initialized,
			  Ram_data_out => Dma_data_out,
           Ram_address =>dma_wr_Address4, 	--accs au stockage
           Ram_wr =>Ex4_Ram_wr, 			--activation de l'criture en RAM
           Ram_data_in =>Dma_data_in4,	   --donnes  crire en RAM
			  DMA_rd_Request => dma_rd_request(4),
			  DMA_rd_grant => dma_rd_grant(4),
			  DMA_wr_Request => dma_wr_request(4),
			  DMA_wr_grant => dma_wr_grant(4),
           AppAck =>AppAck,
           AppReq =>InitReq,
			  PortId=>PortId,
			  port_in_cmd_en => Noc3.port_in_cmd_en,
			  port_in_wr_en =>Noc3.port_in_wr_en,
			  port_in_empty =>Noc3.port_in_empty,
           port_in_full =>Noc3.port_in_full,
           port_in_data =>Noc3.port_in_data,
			  port_out_data =>Noc3.port_out_data,
           port_out_rd_en =>Noc3.port_out_rd_en,
           port_out_data_available =>Noc3.port_out_data_available


);
--=============Mux des signaux d'accs  la RAM=========
ram_we<='1' when (weram='1' and ram_wev ='1') else '0'; -- le contrleur DMA contrle directement
Ram_en<= '1' when (rdram ='1' or weram='1')  else '0'; -- les signaux qui vont vers la RAM 

 --dma_data_in <=dma_data_in1 or dma_data_in2;
 --dma_data_out <=dma_data_out1 or dma_data_out2;
 mux_ad_ram_rd:process (dma_rd_grant,dma_rd_address1,dma_rd_address2,dma_rd_address3,
								ex1_ram_rd, Ex2_ram_rd, Exi_ram_rd )
begin
   case dma_rd_grant is
      when "0001" => dma_rd_address <= dma_rd_address1;
							rdram<= ex1_ram_rd;
      when "0010" => dma_rd_address <= dma_rd_address2;
							rdram<= ex2_ram_rd;
      when "0100" => dma_rd_address <= dma_rd_address3;
							rdram<= exi_ram_rd;
--      when "1000" => dma_rd_address <= <input4>;
      when others => dma_rd_address <= (others =>'0');
							rdram<='0';
   end case;
end process;
 mux_ad_ram_wr:process (dma_wr_grant,dma_wr_address1,dma_wr_address2,dma_wr_address4,Dma_data_in1,Dma_data_in2,Dma_data_in4,
                    ex1_ram_wr,ex2_ram_wr,ex4_ram_wr)
begin
   case dma_wr_grant is
      
		when "0001" => dma_wr_address <= dma_wr_address1;
							weram<=ex1_ram_wr ;
							Dma_data_in<=Dma_data_in1;
		when "0010" => dma_wr_address <= dma_wr_address2;
							weram<=ex2_ram_wr ;
							Dma_data_in<=Dma_data_in2;
      when "1000" => dma_wr_address <= dma_wr_address4;
							weram<=ex4_ram_wr;
							Dma_data_in<=Dma_data_in4;
      when others => dma_wr_address <= (others =>'0');
							weram<='0';
   end case;
end process;
--======================================================

--=================Mux des signaux qui vont au switch============  
 clkout<=clk;   -- permettra le lien avec le module du switch 

 NOC1.port_out_data<=switch_port_out_data; 
 NOC1.port_out_data_available<=switch_port_out_data_vailaible;
 NOC1.port_in_empty<=switch_port_in_empty;
 NOC1.port_in_full<=switch_port_in_full;
 
 NOC2.port_out_data<=switch_port_out_data; 
 NOC2.port_out_data_available<=switch_port_out_data_vailaible;
 NOC2.port_in_empty<=switch_port_in_empty;
 NOC2.port_in_full<=switch_port_in_full;
 
 NOC3.port_out_data<=switch_port_out_data; 
 NOC3.port_out_data_available<=switch_port_out_data_vailaible;
 NOC3.port_in_empty<=switch_port_in_empty;
 NOC3.port_in_full<=switch_port_in_full;
 mux_Noc:process (Ex_en,Noc1,Noc2,Noc3,switch_port_out_data_vailaible,Initialized,Initreq2,
 ex2_i_fifo2_wr_en,ex2_i_fifo2_data_in,ex4_i_fifo2_data_in,ex4_i_fifo2_wr_en,
 instruction,ex2_result)

begin
     case Ex_en is 
	  
	  when"0001" =>
			   switch_port_in_data <=Noc1.port_in_data;
			   switch_port_out_rd_en<=NOC2.port_out_rd_en;
			   switch_port_in_wr_en <=NOC1.port_in_wr_en;
			   switch_port_in_cmd_en <='0';
	  when "0010"|"0011" =>
				switch_port_in_data <=Noc1.port_in_data;
				switch_port_out_rd_en<=NOC2.port_out_rd_en;
				switch_port_in_wr_en <=NOC1.port_in_wr_en;
				switch_port_in_cmd_en <='0';
				 i_fifo2_wr_en<=ex2_i_fifo2_wr_en;
		     i_fifo2_data_in<=ex2_i_fifo2_data_in;
	 when"1011" => --ce cas pose problme car on ne sait ce qui se passe !!!
			  if initreq2='1' then
			    switch_port_in_data <=Noc1.port_in_data;
			   switch_port_out_rd_en<=NOC3.port_out_rd_en;
			   switch_port_in_wr_en <=NOC1.port_in_wr_en;
			    switch_port_in_cmd_en <='0';
			    else
			   switch_port_in_data <=Noc1.port_in_data;
			   switch_port_out_rd_en<=NOC2.port_out_rd_en;
			   switch_port_in_wr_en <=NOC1.port_in_wr_en;
			   switch_port_in_cmd_en <='0';
			   end if;
				i_fifo2_wr_en<=ex2_i_fifo2_wr_en;
		     i_fifo2_data_in<=ex2_i_fifo2_data_in;
	  when "1001"  =>   --ca o un appel  init est effectu
				if initialized='0' then
				switch_port_in_data <=Noc3.port_in_data;
				switch_port_out_rd_en<=NOC3.port_out_rd_en;
				switch_port_in_wr_en <=NOC3.port_in_wr_en;
				switch_port_in_cmd_en <=NOC3.port_in_cmd_en;
      else
        switch_port_in_data <=Noc1.port_in_data;
			   switch_port_out_rd_en<=NOC3.port_out_rd_en;
			   switch_port_in_wr_en <=NOC1.port_in_wr_en;
			 end if;
				i_fifo2_wr_en<=ex4_i_fifo2_wr_en;
		     i_fifo2_data_in<=ex4_i_fifo2_data_in;
	 when "1010"   =>   --ca o un appel  init est effectu
				--switch_port_in_data <=Noc3.port_in_data;
--				switch_port_out_rd_en<=NOC3.port_out_rd_en;
--				switch_port_in_wr_en <=NOC3.port_in_wr_en;
--				switch_port_in_cmd_en <=NOC3.port_in_cmd_en;
        switch_port_in_data <=Noc1.port_in_data;
			   switch_port_out_rd_en<=NOC3.port_out_rd_en;
			   switch_port_in_wr_en <=NOC1.port_in_wr_en;
				i_fifo2_wr_en<=ex4_i_fifo2_wr_en;
		    i_fifo2_data_in<=ex4_i_fifo2_data_in;
	  when others => --permet de grer le cas o un spawn arrive par le rseau
			   switch_port_in_data <=Noc3.port_in_data;
				switch_port_out_rd_en<=NOC3.port_out_rd_en;
				switch_port_in_wr_en <=NOC3.port_in_wr_en;
				switch_port_in_cmd_en <=NOC3.port_in_cmd_en;

				i_fifo2_wr_en<=ex4_i_fifo2_wr_en;
		     i_fifo2_data_in<=ex4_i_fifo2_data_in;
		end  case;  
				    		Instr_in <=Instruction ;
		if initreq2='1' and Ex_en(4)='1' then
		    		Instr_in <=Ex2_Result ;
		  else
		    		Instr_in <=Instruction ;
		  end if;
		  i_fifo2_wr_en<=ex2_i_fifo2_wr_en;
		     i_fifo2_data_in<=ex2_i_fifo2_data_in;
	end process;


--===============================================================
MPI_CORE_DMA_ARBITER: DMA_ARBITER PORT MAP(
		clk =>clk,
		reset =>reset,
		
		data_wr_mem => ram_data_in, --vers RAM
		  
		data_rd_mem => Ram_data_out, --- Vers RAM 
		address_rd =>dma_rd_address,
		address_wr =>dma_wr_address,
		address_out_rd =>ram_address_rd,
		address_out_wr =>ram_address_wr,
		ram_en => ram_env,  --validation lecture
		ram_we =>ram_wev,  --validation criture
		hold_req=>hold_req,--demande de bus  l'application
		hold_ack=>hold_ack, -- libration du bus RAM par l'application
		
		data_rd_out => Dma_data_out, --vers priphrique
		data_wr_in =>Dma_data_in,   --vers priphrique
		dma_wr_grant =>dma_wr_grant,
		dma_rd_request => dma_rd_request,
		dma_rd_grant => dma_rd_grant,
		dma_wr_request => dma_wr_request 
	);
	

CORE_SCHEDULER: MPI_CORE_SCHEDULER PORT MAP( -- permet de slectionner la source de l'instruction 
														-- qui sera excute par la MAE EX1
		clk => clk,
		reset => reset,
		priority_rotation =>scheduler_priority_rotation,
		instruction_fifo_empty =>i_fifo1_empty,
		get_request_fifo_empty => i_fifo2_empty,
		instruction_fifo_rd_en =>i_fifo1_rd_en,
		get_request_fifo_rd_en =>i_fifo2_rd_en ,
		instruction_fifo_data =>i_fifo1_data_out,
		get_request_fifo_data =>i_fifo2_data_out,
		fifo_selected =>fifo_sel,
		instruction_available => fifo_instr,
		fifo_empty => scheduler_fifo_empty,
		fifo_rd_en =>scheduler_rd_en,
		data_out => scheduler_data_out
	);

end structural;

