----------------------------------------------------------------------------------
-- Company: 
-- Engineer: GAMOM / KIEGAING
-- 
-- Create Date:    09:22:58 05/20/2011 
-- Design Name: 
-- Module Name:    EX3_FSM - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
-- module du core mpi charg d'excuter les fonctions mpi_get_size et mpi_get_rank
-- Dependencies: 
--
-- Revision: 23/02/2012
-- Revision 0.02 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
--package Packet_type
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use Work.Packet_type.ALL;
Library NocLib;
use NocLib.CoreTypes.all;
---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity EX3_FSM is
 generic (
				pid : unsigned(Word-1 downto 0) :=  "00000001"; -- id du processeur
				nprocs : unsigned(Word-1 downto 0):="00000011"-- nombre de processeur du MPSOC
			);
    Port ( instruction : in  STD_LOGIC_VECTOR (Word-1 downto 0);
           ResOut : out  STD_LOGIC_VECTOR (Word-1 downto 0);
			  pid_nprocs: out  STD_LOGIC_VECTOR (Word-1 downto 0);
           clk : in  STD_LOGIC;
			  IsMain: in STD_LOGIC;
           reset : in  STD_LOGIC);
end EX3_FSM;


architecture Behavioral of EX3_FSM is

signal instruction_signal : std_logic_vector(3 downto 0);
signal rank : unsigned(Word-1 downto 0) := pid;
signal size : unsigned(Word-1 downto 0) := nprocs;
begin
instruction_signal <= instruction(7 downto 4);
ex3_fsm_process : process(clk)
begin


if rising_edge(clk) then
 if reset ='1' then
   ResOut <= (others=>'0');
 else
  if instruction_signal = MPI_GET_RANK then
   ResOut <=  std_logic_vector(rank);
  elsif instruction_signal = MPI_GET_SIZE then
   ResOut <=  std_logic_vector(size);
	elsif instruction_signal=MPI_INIT then
	if IsMain='1' then  --master est associ  la bibliothque de rang 0
	rank<=rank+1;    -- elle est responsable d'affecter de nouveaux rangs
	end if;
 end if;
 end if; 
end if;
end process;
end Behavioral;

