----------------------------------------------------------------------------------
-- Company: 
-- Engineer: 
-- 
-- Create Date:    20:30:11 08/01/2013 
-- Design Name: 
-- Module Name:    SetBit - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description: 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
Library NocLib;
use NoCLib.CoreTypes.all;
--use work.packet_type.all;
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
--use IEEE.NUMERIC_STD.ALL;

-- Uncomment the following library declaration if instantiating
-- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity SetBit is
    Port ( clk : in  STD_LOGIC;
           reset : in  STD_LOGIC;
			  BitMask : in std_logic_vector(Word-1 downto 0);
			  BitVal : in std_logic;
			  whole : in std_logic;			  
			  dma_wr_grant : in  STD_LOGIC;
				dma_wr_request : out  STD_LOGIC;
				dma_rd_grant : in  STD_LOGIC;
				dma_rd_request : out  STD_LOGIC;
				ram_rd : out std_logic;
				ram_wr : out std_logic;
				start : in std_logic;
				done :  out std_logic;
				ram_address : in std_logic_vector(ADRLEN-1 downto 0);--accs au stockage
				Ram_data_in : out STD_LOGIC_VECTOR (Word-1 downto 0);
				Ram_data_out : in STD_LOGIC_VECTOR (Word-1 downto 0));
end SetBit;

architecture Behavioral of SetBit is
signal n,State,Next_State:natural range 0 to 15 :=0;
signal dma_rd,dma_wr,rd_ok ,wr_ok:std_logic:='0';
begin
PSetBit_sync:process(clk,reset)

begin
if rising_edge(clk) then
if reset='1' then
	n<=0;
	State<=0;
else
  State<=Next_State;
end if;
end if;
end process;

PSetBit:process (State,Start,whole,BitMask,BitVal,Dma_rd_grant,Dma_wr_grant,ram_data_out)
  variable tempval : std_logic_vector(Word-1 downto 0);
  begin
    Next_State<=State;

    
if State >0  then     
			
		dma_wr<='1';  --demander un accs exclusif au bus
		dma_rd<='1'; -- pour viter une mauvaise mise  jour des donnes
	else
		dma_wr<='0';										
		dma_rd<='0';
	end if;
case State is
when 0 =>
  rd_ok<='0';
		Wr_ok<='0';
		done<='0';
	if  start='1' and whole='1' then
	 Next_State<=5;
	 wr_ok<='1';
	 ram_data_in<=bitmask;
	 elsif start='1' then
		Next_State<=State+1;
		end if;
		
when 1=>	if dma_rd_grant='1' then
		Next_State<=State+1;
		
		end if;
		rd_ok<='1';
		wr_ok<='0';
		done<='0';
	When 2|3=>
		if dma_rd_grant='1' then --cycle d'attente
			Next_State<=State+1;
		else
		  Next_State<=1; --recommencer l'attente si perte de priorit
		end if;
			rd_ok<='1';
			wr_ok<='0';
			done<='0';
	When 4 =>
			if dma_rd_grant='1' and dma_wr_grant='1' then
				Next_State<=6;
				tempval:=Ram_data_out;
				if bitval='1' then 
					tempval:= tempval or BitMask;  	
				else
					tempval:= tempval and not (BitMask);
				end if;
				if whole='1' then
				  ram_data_in<=bitmask;
				 else
				  ram_data_in<=tempval;
				end if;
				rd_ok<='1';
				wr_ok<='1';
			else
			  Next_State<=State;
			  report "SetBit:Impossible d'avoir accs en R/W  la RAM";
			end if;
	When 5 =>
	  if dma_wr_grant='1' then
	       if whole='1' then
				    ram_data_in<=bitmask;
				 else
				    ram_data_in<=tempval;
				end if;
				Next_State<=6;
		end if;
		wr_ok<='1';
	When 6=>
		done<='1';
		if start='0' then
    		Next_State<=0;
 	    wr_ok<='0';	
		end if;
		rd_ok<='0';
		wr_ok<='1';
	When others =>
	  Next_State<=0;
	  rd_ok<='0';
		wr_ok<='0';
		done<='0';
end case;

end process PSetBit;
dma_rd_request <= dma_rd;
dma_wr_request <=dma_wr;
Ram_wr<=wr_ok;
Ram_rd<=rd_ok;
--Ram_data_out<=data_to_ram;
 
end Behavioral;

