entity HT_process is
generic (Task_id : natural:=0);
Port ( clk : in  STD_LOGIC;
reset : in  STD_LOGIC;
  en : in std_logic; -- active la tche
Interf_i : in  core_i; --signaux pour l'interface IO
  Interf_o : out  core_o; --signaux pour l'interface IO
mem_o : out typ_dpram_o; -- signaux pour l'accs  la mmoire
  mem_i : in typ_dpram_i -- signaux pour l'accs  la mmoire
  );
end HT_process;

architecture Behavioral of HT_process is

  type typ_mae is (start,Fillmem,NextFill,InitApp,GetRank,WInCreate,WinPost,WinStart,
  putdata,getdata,WinWait,WinCompleted,MpiSpawn,finalize,st_timeout);
	signal sram : typ_dpram;
	signal MyGroup:mpi_group;
	signal MyWin : mpi_win;
	signal MyRank :std_logic_vector(3 downto 0);
	signal intercomm,array_of_errcodes : natural;
signal Libr : Core_io;  --regroupe tous les signaux IO de la bibliothque
signal RunState : typ_mae;

begin

--MAE du PE
--=======================================================================
-- Interf<=Libr;


 pPutGet:process(clk,reset,en)
 

variable destrank : natural range 0 to 15;
variable timeout,ct,dlen,dcount : natural range 0 to 255;
variable SrcAdr,DestAdr : std_logic_vector(ADRLEN-1 downto 0);
variable mywin : Mpi_win;
variable command , argv , maxprocs , info , root : natural:=0; --variable pour le spawn 
variable  adresse,adresse_rd :natural range 0 to 65536;

begin
        
if (clk'event and clk='1') and en='1' then 
	
	
if reset='1' then
--set the default signals values
		
		Libr.O.MemBusy<='0';
		Libr.O.Instr_En<='0';
		sram.O.we<='0';
		sram.O.ena<='0';
		sram.O.enb<='0';
		RunState<=start; --jump to the first state of the FSM
else
	--==========================================================
	--affectation des entres sorties mmoires
	--These signals binding must remain unchanged for proper functionning of the template !
	sram.i.data_out<=mem_I.data_out;
	mem_o.addr_wr<=sram.O.addr_wr;
	mem_o.addr_rd<=sram.O.addr_rd ; 
	mem_o.we<=sram.O.we;
	mem_o.ena<=sram.O.ena;
	mem_o.enb<=sram.O.enb;
	mem_o.data_in<=sram.O.data_in;
	--affectation des entres sorties MPI_HCL
	Interf_o.Instr_EN<=Libr.O.instr_en;
	Interf_o.Membusy<=Libr.O.MemBusy;
	Interf_o.Instruction<=Libr.O.Instruction;
	Libr.i.Instr_ack<=Interf_i.Instr_ack;
	Libr.i.InitOk<=Interf_i.InitOk;
	Libr.i.Hold_Req<=Interf_i.Hold_req;
	Libr.i.RamSel<=Interf_i.RamSel;
	--============================================================
	
	case  RunState is
	when start =>
		adresse:=10;dcount:=0;
		RunState<=Fillmem;
	 when Fillmem => --this state demonstrate a simple example task that writes data in the communication RAM
			sram.O.we<='1'; --enables writting
			sram.O.ena<='1'; 
			sram.O.enb<='0'; --disable reading on port B
		if Libr.I.Ramsel='0' then 	--test if the RAM is free
			sram.O.addr_wr<=std_logic_vector(to_unsigned(adresse,ADRLEN));
			sram.O.data_in<=std_logic_vector(to_unsigned(dcount,8)); -- x"0f";
			Libr.O.MemBusy<='1'; --prevent the MPI-HCL to gain control on the RAM
			dcount:=dcount+1;
			
			if dcount=250 then
				  RunState<=InitApp;
				Libr.O.MemBusy<='0'; --release the RAM access
			else
				adresse:=adresse+1;
				RunState<=Fillmem;
			end if;
	else -- attente de la libraion de la mmoire /waiting for Ram to be free
			timeout:=timeout+1;
			  if timeout=200 then
				report "The RAM is been busy for too long!!!";
				timeout:=0;
			  end if;
					
	end if;

when InitApp =>
		dlen:=15;

		pMPI_Init(ct,Libr,Clk,SRam);

		if ct=0 then 
			RunState<=GetRank;
		end if;

when GetRank =>

	pMPI_Comm_rank(ct,Libr,sram,MPI_COMM_WORLD,MyRank);

	if ct=0 then
		RunState<=WinCreate;

	end if;

when Wincreate => --ici nous personalisons les HT en fonction de leur rang
--we use this state to fix  HT parameters in regard of thier rank
case MyRank is
when x"0"=>
  Mygroup.grp<=x"0000";-- No rank in this group  ==> No Win_Post
  MyGroup.nb<=2;
  destRank:=1;
when x"1" =>
  Mygroup.grp<=x"000A";--  rank 1 and 3 in this group
  destRank:=0;        -- not use by this HT instance 
  DestAdr:=X"043F";
when x"2" =>
  Mygroup.grp<=x"0000";-- no rank in this group
  destRank:=1;
  DestAdr:=X"044F";
when x"3" =>
  Mygroup.grp<=x"0004";-- rank 2 in this group
  destRank:=0;		-- not use by this HT instance 
  DestAdr:=X"045F";
when others =>
  Mygroup.grp<=x"0000";
  destRank:=0;
end case;
		 RunState<=WinPost;
when WinPost =>
	
	pMPI_Win_Post(ct,Libr,sram,MyGroup,0,MyWin);
	if ct=0 then
	RunState<=WinStart;

	end if;
	
when WinStart =>
	pMPI_Win_start(ct,Libr,sram,MyGroup,0,MyWin);

	if ct=0 then
		RunState<=PutData;
	end if;
when putdata => --construire le packet pour le Put

	SrcAdr:=X"000A"; 
	pMPI_put(ct,Libr,Clk,Sram,SrcAdr,Dlen,MPI_int,destrank,DestAdr,Dlen,Mpi_int,Default_win);	
	if ct=0 then
		RunState<=GetData;
	end if;
	
	
when getdata =>  				
	SrcAdr:=X"006D";
	destrank:=3;
	if unsigned(MyRank) = 2 then 
		pMPI_GET(ct,Libr,Clk,Sram,SrcAdr,Dlen,MPI_int,destrank,DestAdr,Dlen,Mpi_int,Default_win);
	end if;

	if ct=0 then
	  
		RunState<=wincompleted;

	end if;

when WinCompleted =>

	 pMPI_Win_Complete(ct,Libr,sram,MyWin );					
	if ct=0 then
		RunState<=WinWait;	
		
	end if;	  
when WinWait =>
	
	 pMPI_Win_wait(ct,Libr,sram,MyWin );

	if ct=0 then
		RunState<=Finalize;	
	end if;	  

when finalize =>

		if ct=0 then
			RunState<=start;	
			
		end if;	 
when others =>
	RunState<=start;
end case;

end if;
end if;

  end process pPutGet;	

end Behavioral;
