/********************************************************************
 *                    COPYRIGHT LIP6 2014
 *-----------------------------------------------------------------*/
/** 
 * @file    audio_codec.v
 * @brief   Performs Audio Compression
 *
 * This module perfoms audio compression of raw data received from AvalonST sink and sends
 * the compressed audio via AvalonST source to stream merger module
 *
 * @author  S. Z. Ahmed 	<syed-zahid.ahmed@lip6.fr>
 * @author  L. Lambert  	<laurent.lambert@lip6.fr>
 * @date    Fri. 28 Feb. 2014
 * 
 * Revision History
 * @version  V1.0  Fri. 28 Feb. 2014 {Initial Arch.: Template file created with qsys gui}
 *
 *******************************************************************/

`timescale 1 ps / 1 ps
module audio_codec #(
		parameter AUTO_CLOCK_CLOCK_RATE = "-1"
	) (
		input  wire        clk,                //      clock.clk
		input  wire        reset,              //      reset.reset
		input  wire [31:0] asi_raw_audio_data,       //        raw_audio.data
		output wire        asi_raw_audio_ready,      //           .ready
		input  wire        asi_raw_audio_valid,      //           .valid
		input  wire [7:0]  avs_ctrl_address,     //       ctrl.address
		input  wire        avs_ctrl_read,        //           .read
		output wire [31:0] avs_ctrl_readdata,    //           .readdata
		input  wire        avs_ctrl_write,       //           .write
		input  wire [31:0] avs_ctrl_writedata,   //           .writedata
		output wire        avs_ctrl_waitrequest, //           .waitrequest
		output wire [31:0] aso_comp_audio_data,      // comp_audio.data
		input  wire        aso_comp_audio_ready,     //           .ready
		output wire        aso_comp_audio_valid      //           .valid
	);

	// TODO: Auto-generated HDL template

	assign asi_raw_audio_ready = 1'b0;

	assign avs_ctrl_waitrequest = 1'b0;

	assign avs_ctrl_readdata = 32'b00000000000000000000000000000000;

	assign aso_comp_audio_valid = 1'b0;

	assign aso_comp_audio_data = 32'b00000000000000000000000000000000;

endmodule
