/********************************************************************
 *                    COPYRIGHT LIP6 2014
 *-----------------------------------------------------------------*/
/** 
 * @file    synchro.v
 * @brief   Creats video trigger, time-stamp/sync clock and rest signal (for ETIS)
 *
 * This module generates the Video trigger signal for the Camera at the choosen fps. It also generates the time-stamp/sync clock that is
 * used by both Acquision (ETIS) and Compression (Lip6) boards for time-stamp counters along with a start signal whic resets the time-stamp
 * counters when the acquisition start command comes from PC (Acacia). The value of time-stamp register is transmitted to the Video coder via AvalonST source 
 *
 * @author  S. Z. Ahmed 	<syed-zahid.ahmed@lip6.fr>
 * @author  L. Lambert  	<laurent.lambert@lip6.fr>
 * @date    Fri. 28 Feb. 2014
 * 
 * Revision History
 * @version  V1.0  Fri. 28 Feb. 2014 {Initial Arch.: Template file created with qsys gui}
 *
 *******************************************************************/

`timescale 1 ps / 1 ps
module synchro (
		input  wire [7:0]  avs_ctrl_address,        //           ctrl.address
		input  wire        avs_ctrl_read,           //             .read
		output wire [31:0] avs_ctrl_readdata,       //             .readdata
		input  wire        avs_ctrl_write,          //             .write
		input  wire [31:0] avs_ctrl_writedata,      //             .writedata
		output wire        avs_ctrl_waitrequest,    //             .waitrequest
		input  wire        clk,                   //        clock.clk
		input  wire        reset,                 //        reset.reset
		output wire        video_trigger,         // conduit_sync.export
		output wire        etis_sync_clock,       //             .export
		output wire        etis_sync_clock_start,  //             .export
		output wire [31:0] aso_ts_data,      // ts.data
		input  wire        aso_ts_ready,     //           .ready
		output wire        aso_ts_valid      //           .valid
	);

	// TODO: Auto-generated HDL template

	assign avs_ctrl_waitrequest = 1'b0;

	assign avs_ctrl_readdata = 32'b00000000000000000000000000000000;

	assign video_trigger = 1'b0;

	assign etis_sync_clock_start = 1'b0;

	assign etis_sync_clock = 1'b0;

endmodule
