/********************************************************************
 *                    COPYRIGHT LIP6 2014
 *-----------------------------------------------------------------*/
/** 
 * @file    signal_grabber.v
 * @brief   Performs signal grabbing of EXG and Audio data coming from ETIS
 *
 * This module performs grabbing of time-stamped EXG and Audio data coming from ETIS (In initial versions create dummy/test data via internal logic of
 * this module for validation of rest of the system). It sends the data received/Modeled from/of ETIS to Audio and EXG coders via AvalonST source
 *
 * @author  S. Z. Ahmed 	<syed-zahid.ahmed@lip6.fr>
 * @author  L. Lambert  	<laurent.lambert@lip6.fr>
 * @date    Fri. 28 Feb. 2014
 * 
 * Revision History
 * @version  V1.0  Fri. 28 Feb. 2014 {Initial Arch.: Template file created with qsys gui}
 *
 *******************************************************************/

`timescale 1 ps / 1 ps
module signal_grabber #(
		parameter ctrl_addr_width = 32,
		parameter ctrl_data_width = 32,
		parameter audio_str_width = 32,
		parameter exg_str_width   = 32,
		parameter etis_si_width   = 32
	) (
		input  wire        clk,                // clock.clk
		input  wire        reset,              // reset.reset
		input  wire [ctrl_addr_width-1:0] avs_ctrl_address,     //  ctrl.address
		input  wire        avs_ctrl_read,        //      .read
		output wire [31:0] avs_ctrl_readdata,    //      .readdata
		input  wire        avs_ctrl_write,       //      .write
		input  wire [31:0] avs_ctrl_writedata,   //      .writedata
		output wire        avs_ctrl_waitrequest, //      .waitrequest
		output wire [31:0] aso_raw_audio_data,      // audio.data
		input  wire        aso_raw_audio_ready,     //      .ready
		output wire        aso_raw_audio_valid,     //      .valid
		output wire [31:0] aso_raw_exg_data,      //   exg.data
		input  wire        aso_raw_exg_ready,     //      .ready
		output wire        aso_raw_exg_valid
	);

	// TODO: Auto-generated HDL template

	assign avs_ctrl_waitrequest = 1'b0;

	assign avs_ctrl_readdata = 32'b00000000000000000000000000000000;

	assign aso_raw_audio_valid = 1'b0;

	assign aso_raw_audio_data = 32'b00000000000000000000000000000000;

	assign aso_raw_exg_valid = 1'b0;

	assign aso_raw_exg_data = 32'b00000000000000000000000000000000;

	assign asi_etis_ready = 1'b0;

endmodule
