/********************************************************************
 *                    COPYRIGHT LIP6 2014
 *-----------------------------------------------------------------*/
/** 
 * @file    frame_grabber.v
 * @brief   Performs frame grabbing, Bayer->RGB conversion and sends the raw data to video codec module
 *
 * This module perfoms the frame grabbing of the terasic D5M camera that is connected with GPIO of DE4, it then
 * performs Bayer->RGB conversion and sends the raw data to the video codec via AvalonST source
 *
 * @author  S. Z. Ahmed 	<syed-zahid.ahmed@lip6.fr>
 * @author  L. Lambert  	<laurent.lambert@lip6.fr>
 * @date    Fri. 28 Feb. 2014
 * 
 * Revision History
 * @version  V1.0  Fri. 28 Feb. 2014 {Initial Arch.: Template file created with qsys gui}
 *
 *******************************************************************/

`timescale 1 ps / 1 ps
module frame_grabber (
		input  wire        clk,                //     clock.clk
		input  wire        reset,              //     reset.reset
		input  wire [7:0]  avs_ctrl_address,     //      ctrl.address
		input  wire        avs_ctrl_read,        //          .read
		output wire [31:0] avs_ctrl_readdata,    //          .readdata
		input  wire        avs_ctrl_write,       //          .write
		input  wire [31:0] avs_ctrl_writedata,   //          .writedata
		output wire        avs_ctrl_waitrequest, //          .waitrequest
		output wire [31:0] aso_raw_video_data,      // raw_video.data
		input  wire        aso_raw_video_ready,     //          .ready
		output wire        aso_raw_video_valid,      //          .valid
		
		input		    [11:0]		D5M_D,
		output		          		D5M_RESETn,
		input		          		D5M_FVAL,
		input		          		D5M_LVAL,
		input		          		D5M_PIXLCLK,
		output		          		D5M_SCLK,
		inout		          		D5M_SDATA,
		input		          		D5M_STROBE,
		output		          		D5M_TRIGGER,
		output		          		D5M_XCLKIN
	);

	// TODO: Auto-generated HDL template

	assign avs_ctrl_waitrequest = 1'b0;

	assign avs_ctrl_readdata = 32'b00000000000000000000000000000000;

	assign aso_out0_valid = 1'b0;

	assign aso_out0_data = 32'b00000000000000000000000000000000;

endmodule
