/********************************************************************
 *                    COPYRIGHT LIP6 2014
 *-----------------------------------------------------------------*/
/** 
 * @file    stream_merger.v
 * @brief   Receives time-stamped {Downscaled RAW Video, Compressed Video, Raw EXG, Compressed EXG, Compressed Audio)
 *          and sends them to tramission Card (exptected to be via HSMC)
 *
 * This module receives three components of SmartEEG data.
 * 1- Time-stamped downscaled RAW (for live privew) and Compressed Video from the Video coder via AvalonST sinks.
 * 2- Time stamped compressed Audio via AvalonST sink
 * 3- Time stamped RAW and Compressed EXG data via AvalonST sinks
 * It transmits these data channels to transmitter card (ARM-based CycloneV FPGA SocKit board connected via HSMC)
 *
 * @author  S. Z. Ahmed 	<syed-zahid.ahmed@lip6.fr>
 * @author  L. Lambert  	<laurent.lambert@lip6.fr>
 * @date    Fri. 28 Feb. 2014
 * 
 * Revision History
 * @version  V1.0  Fri. 28 Feb. 2014 {Initial Arch.: Template file created with qsys gui}
 *
 *******************************************************************/

`timescale 1 ps / 1 ps
module stream_merger #(
		parameter AUTO_CLOCK_CLOCK_RATE = "-1"
	) (
		input  wire        clk,                //     clock.clk
		input  wire        reset,              //     reset.reset
		input  wire [7:0]  avs_ctrl_address,     //      ctrl.address
		input  wire        avs_ctrl_read,        //          .read
		output wire [31:0] avs_ctrl_readdata,    //          .readdata
		input  wire        avs_ctrl_write,       //          .write
		input  wire [31:0] avs_ctrl_writedata,   //          .writedata
		output wire        avs_ctrl_waitrequest, //          .waitrequest
		input  wire [31:0] asi_raw_video_data,       // raw_video.data
		output wire        asi_raw_video_ready,      //          .ready
		input  wire        asi_raw_video_valid,       //          .valid
		input  wire [31:0] asi_raw_exg_data,       // raw_exg.data
		output wire        asi_raw_exg_ready,      //          .ready
		input  wire        asi_raw_exg_valid,       //          .valid
		input  wire [31:0] asi_comp_video_data,       // comp_video.data
		output wire        asi_comp_video_ready,      //          .ready
		input  wire        asi_comp_video_valid,       //          .valid
		input  wire [31:0] asi_comp_exg_data,       // comp_exg.data
		output wire        asi_comp_exg_ready,      //          .ready
		input  wire        asi_comp_exg_valid,       //          .valid
		input  wire [31:0] asi_comp_audio_data,       // comp_audio.data
		output wire        asi_comp_audio_ready,      //          .ready
		input  wire        asi_comp_audio_valid       //          .valid
	);

	// TODO: Auto-generated HDL template

	assign avs_ctrl_waitrequest = 1'b0;

	assign avs_ctrl_readdata = 32'b00000000000000000000000000000000;

	assign asi_in0_ready = 1'b0;

endmodule
