--------------------------------------------------------------------------------
-- Company: 
-- Engineer:
--
-- Create Date:   09:22:05 09/16/2014
-- Design Name:   
-- Module Name:   D:/Synthesis/Static/Timer_Par/test_ld_instr.vhd
-- Project Name:  Timer_Par
-- Target Device:  
-- Tool versions:  
-- Description:   
-- 
-- VHDL Test Bench Created by ISE for module: load_instr
-- 
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- Notes: 
-- This testbench has been automatically generated using types std_logic and
-- std_logic_vector for the ports of the unit under test.  Xilinx recommends
-- that these types always be used for the top-level I/O of a design in order
-- to guarantee that the testbench will bind correctly to the post-implementation 
-- simulation model.
--------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
Library MPI_HCL;
use MPI_HCL.Packet_type.all; 
-- Uncomment the following library declaration if using
-- arithmetic functions with Signed or Unsigned values
USE ieee.numeric_std.ALL;
 
ENTITY test_ld_instr IS
END test_ld_instr;
 
ARCHITECTURE behavior OF test_ld_instr IS 
 
    -- Component Declaration for the Unit Under Test (UUT)
 
    COMPONENT load_instr
    PORT(
         Instruction : IN  std_logic_vector(7 downto 0);
         Instruction_en : IN  std_logic;
         clk : IN  std_logic;
         reset : IN  std_logic;
         dma_rd_grant : IN  std_logic;
         dma_rd_request : OUT  std_logic;
         instruction_ack : OUT  std_logic;
         fifo_din : OUT  std_logic_vector(7 downto 0);
         fifo_wr : OUT  std_logic;
         copying : OUT  std_logic;
         fifo_full : IN  std_logic;
         ram_address_rd : OUT  std_logic_vector(15 downto 0);
         ram_data : IN  std_logic_vector(7 downto 0);
         Ram_rd_en : OUT  std_logic
        );
    END COMPONENT;
type memory is array(natural range <>) of std_logic_vector(7 downto 0);    
function init_mem(size : natural) return memory is
variable dt: memory(0 to size-1);
 begin
 for i in 0 to size-1 loop
 if i<3200 then
 dt(i):=std_logic_vector(to_unsigned(i+32,8));
 else
 dt(i):=std_logic_vector(to_unsigned(0,8));
 end if;
 end loop;
 dt(4098):=x"04";
 dt(4099):=x"12";
 dt(4612):=x"50";
 dt(4613):=x"32";
 dt(4614):=x"01";
 dt(4615):=x"05";
 dt(4616):=x"20";
 dt(4617):=x"00";
 return dt;
 end function;
   --Inputs
   signal Instruction : std_logic_vector(7 downto 0) := (others => '0');
   signal Instruction_en : std_logic := '0';
   signal clk : std_logic := '0';
   signal reset : std_logic := '0';
   signal dma_rd_grant : std_logic := '0';
   signal fifo_full : std_logic := '0';
   signal ram_data : std_logic_vector(7 downto 0) := (others => '0');

 	--Outputs
   signal dma_rd_request : std_logic;
   signal instruction_ack : std_logic;
   signal fifo_din : std_logic_vector(7 downto 0);
   signal fifo_wr : std_logic;
   signal copying : std_logic;
   signal ram_address_rd : std_logic_vector(15 downto 0);
   signal Ram_rd_en : std_logic;
	
	signal mem:memory(0 to 16535):=init_mem(16536);
   -- Clock period definitions
   constant clk_period : time := 10 ns;

BEGIN
 
	-- Instantiate the Unit Under Test (UUT)
   uut: load_instr PORT MAP (
          Instruction => Instruction,
          Instruction_en => Instruction_en,
          clk => clk,
          reset => reset,
          dma_rd_grant => dma_rd_grant,
          dma_rd_request => dma_rd_request,
          instruction_ack => instruction_ack,
          fifo_din => fifo_din,
          fifo_wr => fifo_wr,
          copying => copying,
          fifo_full => fifo_full,
          ram_address_rd => ram_address_rd,
          ram_data => ram_data,
          Ram_rd_en => Ram_rd_en
        );

   -- Clock process definitions
   clk_process :process
   begin
		clk <= '0';
		wait for clk_period/2;
		clk <= '1';
		wait for clk_period/2;
   end process;
 mem_proc:process(clk)
 begin
 if rising_edge(clk) then
 if ram_rd_en='1' then
 ram_data<=mem(to_integer(unsigned(ram_address_rd)));
 end if;
 dma_rd_grant<=dma_rd_request;

 
 
 end if;
 
 end process;
 
 fifo_full<='0';
 instruction<=x"06";
 instruction_en<='0','1' after 200 ns,'0' after 1000 ns;
 
 
res_proc:process
begin
reset<='0';
wait for 30 ns;
reset<='1','0' after 100 ns;
end process;
  

END;
