#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <signal.h>
#include <systemc.h>

#include "chrono.h"
#include "shared/soclib_vci_interfaces.h"
#include "cache/soclib_caches_interfaces.h"
#include "binary/mips_binary.h"

/* VCI template parameters */
const int ERRLEN   = 0;
const short ADDRSIZE = 32;
const short CELLSIZE = 4;

#include "interconnect/soclib_vci_gmn.h"
#include "processor/soclib_multi_mips.h"
#include "cache/soclib_vci_xcache.h"
#include "tty/soclib_vci_tty.h"
#include "systemio/locks/soclib_vci_ramlocks.h"
#include "systemio/timer/soclib_vci_multi_timer.h"
#include "shared/soclib_segment_table.h"
#include "ram/soclib_vci_multiram.h"

/* Max number of cycles to perform */
int max_cycles;

/* signal handler */
void sighandler (int i)
{
	cerr << "Simulation aborted.\n";
	exit (-1);
}


/* main */
int sc_main (int argc, char *argv[])
{

	if (argc!=2)
	{
		printf("Usage : ./system.x nbCyclesToGo\n");
		exit(1);
	}
	sscanf(argv[1],"%d",&max_cycles);

	signal( SIGINT, sighandler );
	signal( SIGTERM, sighandler );

	/************************************************************************
	 *
	 * Signal declaration
	 *
	 ************************************************************************/

	sc_clock signal_clk("clock");
	sc_signal<bool> signal_resetn("resetn");
	ICACHE_SIGNALS _xcache0_ICACHE_mips0_ICACHE;
	DCACHE_SIGNALS _xcache0_DCACHE_mips0_DCACHE;
	ICACHE_SIGNALS _xcache1_ICACHE_mips1_ICACHE;
	DCACHE_SIGNALS _xcache1_DCACHE_mips1_DCACHE;
	ICACHE_SIGNALS _xcache2_ICACHE_mips2_ICACHE;
	DCACHE_SIGNALS _xcache2_DCACHE_mips2_DCACHE;
	ICACHE_SIGNALS _xcache3_ICACHE_mips3_ICACHE;
	DCACHE_SIGNALS _xcache3_DCACHE_mips3_DCACHE;
	ADVANCED_VCI_SIGNALS<ADDRSIZE,CELLSIZE,ERRLEN> _gmn_T_VCI_3__xcache3_VCI;
	ADVANCED_VCI_SIGNALS<ADDRSIZE,CELLSIZE,ERRLEN> _gmn_T_VCI_2__xcache2_VCI;
	ADVANCED_VCI_SIGNALS<ADDRSIZE,CELLSIZE,ERRLEN> _gmn_T_VCI_1__xcache1_VCI;
	ADVANCED_VCI_SIGNALS<ADDRSIZE,CELLSIZE,ERRLEN> _gmn_T_VCI_0__xcache0_VCI;
	ADVANCED_VCI_SIGNALS<ADDRSIZE,CELLSIZE,ERRLEN> _vcitty0_VCI_gmn_I_VCI_0_;
	ADVANCED_VCI_SIGNALS<ADDRSIZE,CELLSIZE,ERRLEN> _vcitty1_VCI_gmn_I_VCI_1_;
	ADVANCED_VCI_SIGNALS<ADDRSIZE,CELLSIZE,ERRLEN> _vcitty2_VCI_gmn_I_VCI_2_;
	ADVANCED_VCI_SIGNALS<ADDRSIZE,CELLSIZE,ERRLEN> _vcitty3_VCI_gmn_I_VCI_3_;
	ADVANCED_VCI_SIGNALS<ADDRSIZE,CELLSIZE,ERRLEN> _locks_VCI_gmn_I_VCI_6_;
	ADVANCED_VCI_SIGNALS<ADDRSIZE,CELLSIZE,ERRLEN> _multitimer_VCI_gmn_I_VCI_5_;
	sc_signal<bool> _multitimer_IRQ_0__mips0_IT_0;
	sc_signal<bool> _multitimer_IRQ_1__mips1_IT_0;
	sc_signal<bool> _multitimer_IRQ_2__mips2_IT_0;
	sc_signal<bool> _multitimer_IRQ_3__mips3_IT_0;
	ADVANCED_VCI_SIGNALS<ADDRSIZE,CELLSIZE,ERRLEN> _multiram0_VCI_gmn_I_VCI_4_;
	ADVANCED_VCI_SIGNALS<ADDRSIZE,CELLSIZE,ERRLEN> _multiram1_VCI_gmn_I_VCI_7_;
	sc_signal<bool> _mips0_IT_5;
	sc_signal<bool> _mips0_IT_4;
	sc_signal<bool> _mips0_IT_3;
	sc_signal<bool> _mips0_IT_2;
	sc_signal<bool> _mips0_IT_1;
	sc_signal<sc_uint<1> > _mips0_D_FRZ;
	sc_signal<sc_uint<1> > _mips0_I_FRZ;
	sc_signal<bool> _mips1_IT_5;
	sc_signal<bool> _mips1_IT_4;
	sc_signal<bool> _mips1_IT_3;
	sc_signal<bool> _mips1_IT_2;
	sc_signal<bool> _mips1_IT_1;
	sc_signal<sc_uint<1> > _mips1_D_FRZ;
	sc_signal<sc_uint<1> > _mips1_I_FRZ;
	sc_signal<bool> _mips2_IT_5;
	sc_signal<bool> _mips2_IT_4;
	sc_signal<bool> _mips2_IT_3;
	sc_signal<bool> _mips2_IT_2;
	sc_signal<bool> _mips2_IT_1;
	sc_signal<sc_uint<1> > _mips2_D_FRZ;
	sc_signal<sc_uint<1> > _mips2_I_FRZ;
	sc_signal<bool> _mips3_IT_5;
	sc_signal<bool> _mips3_IT_4;
	sc_signal<bool> _mips3_IT_3;
	sc_signal<bool> _mips3_IT_2;
	sc_signal<bool> _mips3_IT_1;
	sc_signal<sc_uint<1> > _mips3_D_FRZ;
	sc_signal<sc_uint<1> > _mips3_I_FRZ;

	/************************************************************************
	 *
	 * Segment table
	 *
	 ************************************************************************/

	SOCLIB_SEGMENT_TABLE segtab;
	segtab.setMSBNumber(8);
	segtab.setDefaultTarget(0);
	segtab.addSegment("rom_reset",0xBFC00000,10000,4,false);
	segtab.addSegment("rom_excep",0x80000080,10000,4,false);
	segtab.addSegment("rom_code",0x00400000,50000,4, false);
	segtab.addSegment("ram_util",0x10000000,50000,7, false);
	segtab.addSegment("loc0",0x20000000,20000,7,false);
	segtab.addSegment("loc1",0x21000000,20000,7,false);
	segtab.addSegment("loc2",0x22000000,20000,7,false);
	segtab.addSegment("loc3",0x23000000,20000,7,false);
	segtab.addSegment("tty0",0xA0000000,100,0,true);
	segtab.addSegment("tty1",0xA1000000,100,1,true);
	segtab.addSegment("tty2",0xA2000000,100,2,true);
	segtab.addSegment("tty3",0xA3000000,100,3,true);
	segtab.addSegment("timer",0xB0000000,1000,5,true);
	segtab.addSegment("locks",0xB2000000,10000,6,true);

	/************************************************************************
	 *
	 * Soclib components instanciation
	 *
	 ************************************************************************/

	SOCLIB_VCI_GMN<4,8,2,8,32,4,0> gmn       ("gmn",segtab);
	SOCLIB_MULTI_MIPS<false,1,0>   mips0     ("mips0",0,segtab);
	SOCLIB_VCI_XCACHE<8,8,8,8>     xcache0   ("xcache0",0);
	SOCLIB_MULTI_MIPS<false,1,0>   mips1     ("mips1",1,segtab);
	SOCLIB_VCI_XCACHE<8,8,8,8>     xcache1   ("xcache1",1);
	SOCLIB_MULTI_MIPS<false,1,0>   mips2     ("mips2",2,segtab);
	SOCLIB_VCI_XCACHE<8,8,8,8>     xcache2   ("xcache2",2);
	SOCLIB_MULTI_MIPS<false,1,0>   mips3     ("mips3",3,segtab);
	SOCLIB_VCI_XCACHE<8,8,8,8>     xcache3   ("xcache3",3);
	SOCLIB_VCI_TTY                 vcitty0   ("vcitty0",0,segtab,true);
	SOCLIB_VCI_TTY                 vcitty1   ("vcitty1",1,segtab,true);
	SOCLIB_VCI_TTY                 vcitty2   ("vcitty2",2,segtab,true);
	SOCLIB_VCI_TTY                 vcitty3   ("vcitty3",3,segtab,true);
	SOCLIB_VCI_RAMLOCKS            locks     ("locks",6,segtab);
	SOCLIB_VCI_MULTI_TIMER<4>      multitimer("multitimer",5,segtab);
	SOCLIB_VCI_MULTIRAM            multiram0 ("multiram0",4,segtab);
	SOCLIB_VCI_MULTIRAM            multiram1 ("multiram1",7,segtab);

	/************************************************************************
	 *
	 * Soclib topcell netlist
	 *
	 ************************************************************************/

	gmn.I_VCI[0](_vcitty0_VCI_gmn_I_VCI_0_);
	gmn.I_VCI[3](_vcitty3_VCI_gmn_I_VCI_3_);
	gmn.I_VCI[6](_locks_VCI_gmn_I_VCI_6_);
	gmn.I_VCI[1](_vcitty1_VCI_gmn_I_VCI_1_);
	gmn.I_VCI[4](_multiram0_VCI_gmn_I_VCI_4_);
	gmn.I_VCI[7](_multiram1_VCI_gmn_I_VCI_7_);
	gmn.I_VCI[2](_vcitty2_VCI_gmn_I_VCI_2_);
	gmn.I_VCI[5](_multitimer_VCI_gmn_I_VCI_5_);
	gmn.T_VCI[1](_gmn_T_VCI_1__xcache1_VCI);
	gmn.T_VCI[2](_gmn_T_VCI_2__xcache2_VCI);
	gmn.T_VCI[0](_gmn_T_VCI_0__xcache0_VCI);
	gmn.T_VCI[3](_gmn_T_VCI_3__xcache3_VCI);
	gmn.CLK(signal_clk);
	gmn.RESETN(signal_resetn);

	mips0.DCACHE(_xcache0_DCACHE_mips0_DCACHE);
	mips0.ICACHE(_xcache0_ICACHE_mips0_ICACHE);
	mips0.IT_5(_mips0_IT_5);
	mips0.IT_4(_mips0_IT_4);
	mips0.IT_3(_mips0_IT_3);
	mips0.IT_2(_mips0_IT_2);
	mips0.IT_1(_mips0_IT_1);
	mips0.IT_0(_multitimer_IRQ_0__mips0_IT_0);
	mips0.D_FRZ(_mips0_D_FRZ);
	mips0.I_FRZ(_mips0_I_FRZ);
	mips0.CLK(signal_clk);
	mips0.RESETN(signal_resetn);

	xcache0.VCI(_gmn_T_VCI_0__xcache0_VCI);
	xcache0.DCACHE(_xcache0_DCACHE_mips0_DCACHE);
	xcache0.ICACHE(_xcache0_ICACHE_mips0_ICACHE);
	xcache0.CLK(signal_clk);
	xcache0.RESETN(signal_resetn);

	mips1.DCACHE(_xcache1_DCACHE_mips1_DCACHE);
	mips1.ICACHE(_xcache1_ICACHE_mips1_ICACHE);
	mips1.IT_5(_mips1_IT_5);
	mips1.IT_4(_mips1_IT_4);
	mips1.IT_3(_mips1_IT_3);
	mips1.IT_2(_mips1_IT_2);
	mips1.IT_1(_mips1_IT_1);
	mips1.IT_0(_multitimer_IRQ_1__mips1_IT_0);
	mips1.D_FRZ(_mips1_D_FRZ);
	mips1.I_FRZ(_mips1_I_FRZ);
	mips1.CLK(signal_clk);
	mips1.RESETN(signal_resetn);

	xcache1.VCI(_gmn_T_VCI_1__xcache1_VCI);
	xcache1.DCACHE(_xcache1_DCACHE_mips1_DCACHE);
	xcache1.ICACHE(_xcache1_ICACHE_mips1_ICACHE);
	xcache1.CLK(signal_clk);
	xcache1.RESETN(signal_resetn);

	mips2.DCACHE(_xcache2_DCACHE_mips2_DCACHE);
	mips2.ICACHE(_xcache2_ICACHE_mips2_ICACHE);
	mips2.IT_5(_mips2_IT_5);
	mips2.IT_4(_mips2_IT_4);
	mips2.IT_3(_mips2_IT_3);
	mips2.IT_2(_mips2_IT_2);
	mips2.IT_1(_mips2_IT_1);
	mips2.IT_0(_multitimer_IRQ_2__mips2_IT_0);
	mips2.D_FRZ(_mips2_D_FRZ);
	mips2.I_FRZ(_mips2_I_FRZ);
	mips2.CLK(signal_clk);
	mips2.RESETN(signal_resetn);

	xcache2.VCI(_gmn_T_VCI_2__xcache2_VCI);
	xcache2.DCACHE(_xcache2_DCACHE_mips2_DCACHE);
	xcache2.ICACHE(_xcache2_ICACHE_mips2_ICACHE);
	xcache2.CLK(signal_clk);
	xcache2.RESETN(signal_resetn);

	mips3.DCACHE(_xcache3_DCACHE_mips3_DCACHE);
	mips3.ICACHE(_xcache3_ICACHE_mips3_ICACHE);
	mips3.IT_5(_mips3_IT_5);
	mips3.IT_4(_mips3_IT_4);
	mips3.IT_3(_mips3_IT_3);
	mips3.IT_2(_mips3_IT_2);
	mips3.IT_1(_mips3_IT_1);
	mips3.IT_0(_multitimer_IRQ_3__mips3_IT_0);
	mips3.D_FRZ(_mips3_D_FRZ);
	mips3.I_FRZ(_mips3_I_FRZ);
	mips3.CLK(signal_clk);
	mips3.RESETN(signal_resetn);

	xcache3.VCI(_gmn_T_VCI_3__xcache3_VCI);
	xcache3.DCACHE(_xcache3_DCACHE_mips3_DCACHE);
	xcache3.ICACHE(_xcache3_ICACHE_mips3_ICACHE);
	xcache3.CLK(signal_clk);
	xcache3.RESETN(signal_resetn);

	vcitty0.VCI(_vcitty0_VCI_gmn_I_VCI_0_);
	vcitty0.CLK(signal_clk);
	vcitty0.RESETN(signal_resetn);

	vcitty1.VCI(_vcitty1_VCI_gmn_I_VCI_1_);
	vcitty1.CLK(signal_clk);
	vcitty1.RESETN(signal_resetn);

	vcitty2.VCI(_vcitty2_VCI_gmn_I_VCI_2_);
	vcitty2.CLK(signal_clk);
	vcitty2.RESETN(signal_resetn);

	vcitty3.VCI(_vcitty3_VCI_gmn_I_VCI_3_);
	vcitty3.CLK(signal_clk);
	vcitty3.RESETN(signal_resetn);

	locks.VCI(_locks_VCI_gmn_I_VCI_6_);
	locks.CLK(signal_clk);
	locks.RESETN(signal_resetn);

	multitimer.IRQ[0](_multitimer_IRQ_0__mips0_IT_0);
	multitimer.IRQ[3](_multitimer_IRQ_3__mips3_IT_0);
	multitimer.IRQ[1](_multitimer_IRQ_1__mips1_IT_0);
	multitimer.IRQ[2](_multitimer_IRQ_2__mips2_IT_0);
	multitimer.VCI(_multitimer_VCI_gmn_I_VCI_5_);
	multitimer.CLK(signal_clk);
	multitimer.RESETN(signal_resetn);


	multiram0.VCI(_multiram0_VCI_gmn_I_VCI_4_);
	multiram0.CLK(signal_clk);
	multiram0.RESETN(signal_resetn);

	multiram1.VCI(_multiram1_VCI_gmn_I_VCI_7_);
	multiram1.CLK(signal_clk);
	multiram1.RESETN(signal_resetn);

	/************************************************************************
	 *
	 * Load Application Binaries into memories
	 *
	 ************************************************************************/

	char *sections_rom_reset[]={".reset",NULL};
	MIPS_BINARY mb_rom_reset("a.out",sections_rom_reset);
	multiram0.load("rom_reset",mb_rom_reset);

	char *sections_rom_excep[]={".excep",NULL};
	MIPS_BINARY mb_rom_excep("a.out",sections_rom_excep);
	multiram0.load("rom_excep",mb_rom_excep);

	char *sections_rom_code[]={".text",NULL};
	MIPS_BINARY mb_rom_code("a.out",sections_rom_code);
	multiram0.load("rom_code",mb_rom_code);

	char *sections_ram_util[]={".rodata",".data",".sdata",".sbss",".bss",NULL};
	MIPS_BINARY mb_ram_util("a.out",sections_ram_util);
	multiram1.load("ram_util",mb_ram_util);


	/************************************************************************
	 *
	 * Signal trace management
	 *
	 ************************************************************************/

#ifdef ENABLE_TRACE
	/* Open trace file */
	sc_trace_file *system_trace_file;
	system_trace_file = sc_create_vcd_trace_file ("trace_file");
	
	/* clk and resetn waveforms are always useful */
	sc_trace(system_trace_file, signal_clk, "clk");
	sc_trace(system_trace_file, signal_resetn, "resetn");
	sc_trace(system_trace_file, mips0.PC[0], "mips0.PC");
	sc_trace(system_trace_file, mips1.PC[0], "mips1.PC");
	sc_trace(system_trace_file, mips2.PC[0], "mips2.PC");
	sc_trace(system_trace_file, mips3.PC[0], "mips3.PC");
	sc_trace(system_trace_file, _mips0_IT_5, "_mips0_IT_5");
	sc_trace(system_trace_file, _mips0_IT_4, "_mips0_IT_4");
	sc_trace(system_trace_file, _mips0_IT_3, "_mips0_IT_3");
	sc_trace(system_trace_file, _mips0_IT_2, "_mips0_IT_2");
	sc_trace(system_trace_file, _mips0_IT_1, "_mips0_IT_1");
	sc_trace(system_trace_file, _mips0_D_FRZ, "_mips0_D_FRZ");
	sc_trace(system_trace_file, _mips0_I_FRZ, "_mips0_I_FRZ");
	sc_trace(system_trace_file, _multiram0_VCI_gmn_I_VCI_4_, "_multiram0_VCI_gmn_I_VCI_4_");
	sc_trace(system_trace_file, multiram0.VCI, "multiram0.VCI");
	sc_trace(system_trace_file, gmn.I_VCI[4], "gmn.I_VCI(4)");
	sc_trace(system_trace_file, gmn.I_VCI[3], "gmn.I_VCI(3)");
	sc_trace(system_trace_file, gmn.I_VCI[2], "gmn.I_VCI(2)");
	sc_trace(system_trace_file, gmn.I_VCI[1], "gmn.I_VCI(1)");
	sc_trace(system_trace_file, gmn.I_VCI[0], "gmn.I_VCI(0)");
	sc_trace(system_trace_file, gmn.T_VCI[3], "gmn.T_VCI(3)");
	sc_trace(system_trace_file, gmn.T_VCI[2], "gmn.T_VCI(2)");
	sc_trace(system_trace_file, gmn.T_VCI[1], "gmn.T_VCI(1)");
	sc_trace(system_trace_file, gmn.T_VCI[0], "gmn.T_VCI(0)");
	sc_trace(system_trace_file, _xcache0_ICACHE_mips0_ICACHE, "_ICACHE_mips0");
	sc_trace(system_trace_file, _xcache0_DCACHE_mips0_DCACHE, "_DCACHE_mips0");
#ifdef ENABLE_PAT
	/* Open trace file */
	sc_trace_file *system_trace_file2;
	system_trace_file2 = sc_create_pat_trace_file ("trace_file");
	
	/* clk and resetn waveforms are always useful */
	sc_trace(system_trace_file2, signal_clk, "clk");
	sc_trace(system_trace_file2, signal_resetn, "resetn");
	sc_trace(system_trace_file2, mips0.PC[0], "mips0.PC");
	sc_trace(system_trace_file2, mips1.PC[0], "mips1.PC");
	sc_trace(system_trace_file2, mips2.PC[0], "mips2.PC");
	sc_trace(system_trace_file2, mips3.PC[0], "mips3.PC");
	sc_trace(system_trace_file2, _mips2_IT_5,  "mips2_IT_5");
	sc_trace(system_trace_file2, _mips2_IT_4,  "mips2_IT_4");
	sc_trace(system_trace_file2, _mips2_IT_3,  "mips2_IT_3");
	sc_trace(system_trace_file2, _mips2_IT_2,  "mips2_IT_2");
	sc_trace(system_trace_file2, _mips2_IT_1,  "mips2_IT_1");
	sc_trace(system_trace_file2, _mips2_D_FRZ, "mips2_D_FRZ");
	sc_trace(system_trace_file2, _mips2_I_FRZ, "mips2_I_FRZ");
	sc_trace(system_trace_file2, mips0     .DCACHE, "mips0.DCACHE");
	sc_trace(system_trace_file2, mips0     .ICACHE, "mips0.ICACHE");
	sc_trace(system_trace_file2, mips1     .DCACHE, "mips1.DCACHE");
	sc_trace(system_trace_file2, mips1     .ICACHE, "mips1.ICACHE");
	sc_trace(system_trace_file2, mips2     .DCACHE, "mips2.DCACHE");
	sc_trace(system_trace_file2, mips2     .ICACHE, "mips2.ICACHE");
	sc_trace(system_trace_file2, mips3     .DCACHE, "mips3.DCACHE");
	sc_trace(system_trace_file2, mips3     .ICACHE, "mips3.ICACHE");
	sc_trace(system_trace_file2, xcache0   .VCI, "xcache0.VCI");
	sc_trace(system_trace_file2, xcache1   .VCI, "xcache1.VCI");
	sc_trace(system_trace_file2, xcache2   .VCI, "xcache2.VCI");
	sc_trace(system_trace_file2, xcache3   .VCI, "xcache3.VCI");
	sc_trace(system_trace_file2, vcitty0   .VCI, "vcitty0.VCI");
	sc_trace(system_trace_file2, vcitty1   .VCI, "vcitty1.VCI");
	sc_trace(system_trace_file2, vcitty2   .VCI, "vcitty2.VCI");
	sc_trace(system_trace_file2, vcitty3   .VCI, "vcitty3.VCI");
	sc_trace(system_trace_file2, locks     .VCI, "locks.VCI");
	sc_trace(system_trace_file2, multitimer.VCI, "multitimer.VCI");
	sc_trace(system_trace_file2, multiram0 .VCI, "multiram0.VCI");
	sc_trace(system_trace_file2, multiram1 .VCI, "multiram1.VCI");

#endif

#endif
	
	/******************************************************************************
	 *
	 * Simulation loop
	 *
	 ******************************************************************************/

	sc_initialize ();

	chrono_t chrono;
	chrono.start ();
	signal_resetn = false;
	sc_start(1);
	signal_resetn = true;
	_mips0_IT_5=0;
	_mips0_IT_4=0;
	_mips0_IT_3=0;
	_mips0_IT_2=0;
	_mips0_IT_1=0;
	_mips0_D_FRZ=0;
	_mips0_I_FRZ=0;
	_mips1_IT_5=0;
	_mips1_IT_4=0;
	_mips1_IT_3=0;
	_mips1_IT_2=0;
	_mips1_IT_1=0;
	_mips1_D_FRZ=0;
	_mips1_I_FRZ=0;
	_mips2_IT_5=0;
	_mips2_IT_4=0;
	_mips2_IT_3=0;
	_mips2_IT_2=0;
	_mips2_IT_1=0;
	_mips2_D_FRZ=0;
	_mips2_I_FRZ=0;
	_mips3_IT_5=0;
	_mips3_IT_4=0;
	_mips3_IT_3=0;
	_mips3_IT_2=0;
	_mips3_IT_1=0;
	_mips3_D_FRZ=0;
	_mips3_I_FRZ=0;
	
	sc_start(max_cycles);
/*
	for (int i = 0; i < max_cycles; i++)
	{
		sc_start(1);
			cout << sc_simulation_time () << " cycle : ";
			cout << "PC = " << hex << mips0.PC[0];
			cout << ",IR = " << hex << mips0.IR[0];
			cout << "\n";
		
		if (((int)(sc_simulation_time ()) % 10000) == 0)
		{
			printf("\nElapsed : %10.10d cycles.", (int)(sc_simulation_time ()));
		}
	}
	*/
	chrono.stop ();
	unsigned int d = chrono;
	cout << "Time elapsed (sec) : " << d << endl;
	cout << "Cycles done        : " << sc_simulation_time () << endl;
	cout << "Performance        : " << sc_simulation_time () / d << endl;

	//
#ifdef ENABLE_TRACE
	sc_close_vcd_trace_file (system_trace_file);
#ifdef ENABLE_PAT
	sc_close_pat_trace_file (system_trace_file2);
#endif
#endif
	
	printf("\nPress <RETURN> to exit simulation.");
	char buf_ret[2];
	cin.getline(buf_ret,1);
	
	return EXIT_SUCCESS;
}
