/*------------------------------------------------------------\
|                                                             |
| Tool    :                  systemcass                       |
|                                                             |
| File    :                 hex2string.cc                     |
|                                                             |
| Author  :                 Buchmann Richard                  |
|                                                             |
| Date    :                   09_07_2004                      |
|                                                             |
\------------------------------------------------------------*/

/* 
 * This file is part of the Disydent Project
 * Copyright (C) Laboratoire LIP6 - Dpartement ASIM
 * Universite Pierre et Marie Curie
 * 
 * Home page          : http://www-asim.lip6.fr/disydent
 * E-mail             : mailto:richard.buchmann@lip6.fr
 * 
 * This library is free software; you  can redistribute it and/or modify it
 * under the terms  of the GNU Library General Public  License as published
 * by the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * Disydent is distributed  in the hope  that it  will be
 * useful, but WITHOUT  ANY WARRANTY; without even the  implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy  of the GNU General Public License along
 * with the GNU C Library; see the  file COPYING. If not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "hex2string.h"

//#include <string>
#include <stdarg.h>
#include <cstdio>
#include <cstdlib>
#include <iostream>
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
	
using namespace std;

namespace sc_core {

void 
hex2string(char        *buf,
           const tab_t *val,
           int          bit_number)
{
	int tmp=*((const int*)val);
 	//cout << "tmp = " << tmp << "\n";	
	buf[bit_number >> 2]='\0';
	for (int i = (bit_number >> 2) - 1; i >= 0 ;i--) 
	{
		char value = tmp & 0x0F;
		buf[i]=(value > 9)?('A' + value - 10):('0'+value);
		tmp=tmp>>4;
	}
#if 0
  sscanf (buf, "%X", &tmp);
  if (atoi (buf) != *val)
    cerr << "hex2string (0x" << hex << *val << ") returns 0x" << buf << "    KO !\n";
#endif	
}

} // end of sc_core namespace

