#include <systemc.h>

#define ASSERT(x) \
  { \
    if (!(x)) \
    { \
    cerr << "ASSERT : " #x "\n"; \
    exit (1); \
    } \
  }

using namespace std;

struct inner : sc_module {
	sc_in_clk                       clk;
  sc_in<int>                      i1;
  sc_out<int>                     o1;
  sc_signal<int>                  reg2;

  void trans ()
  {
    reg2 = i1;
  }

  void gen ()
  {
    o1 = reg2.read() + 1;
  }

  SC_HAS_PROCESS(inner);
	inner (sc_module_name n) : sc_module (n),
    clk("clk"),
    i1("i1"), 
    o1("o1"),
    reg2("reg2")
  {
		SC_METHOD(trans);
		sensitive << clk.pos();
    dont_initialize();
		SC_METHOD(gen);
		sensitive << clk.neg();
    dont_initialize();
	};
};

struct test : sc_module {
  inner                           in;
	sc_in_clk                       clk;
  sc_in<int>                      i1;
  sc_out<int>                     o1;
  sc_out<bool>                    o2;

  sc_signal<bool>                 reg1;

  void trans ()
  {
    reg1 = i1 & 1;
  }

  void gen ()
  {
    o2 = reg1.read();
  }

  SC_HAS_PROCESS(test);
	test (sc_module_name n) : sc_module (n), 
    in ("inner"),
    clk("clk"),
    i1("i1"), 
    o1("o1"),
    o2("o2"),
    reg1("reg1")
  {
    in.clk (clk);
    in.o1 (o1);
    in.i1 (i1);
		SC_METHOD(trans);
		sensitive << clk.pos();
    dont_initialize();
		SC_METHOD(gen);
		sensitive << clk.neg();
    dont_initialize();
	};
};

int sc_main (int argc, char *argv[])
{
	sc_clock           signal_clk("my_clock",1, 0.5);
  sc_signal<int>     s01("s01");
  sc_signal<int>     s02("s02");
  sc_signal<bool>    s03("s03");

  test test1("test1");
  test1.clk (signal_clk);
  test1.i1 (s01);
  test1.o1 (s02);
  test1.o2 (s03);

	// Init & run
	sc_start (0);

  int i;
  for (i = 0; i < 10; ++i)
  {
    sc_start (1);
    s01 = i % 2;
#if 0
    cerr << "cycle #" << i << " : " 
         << test1.o1.read() << " ; " 
         <<test1.in.reg2.read () + 1 << endl;
#endif
    ASSERT(test1.o1.read() == test1.in.reg2.read () + 1);
    ASSERT(test1.o1.read() == test1.in.o1.read ());
  }

	return EXIT_SUCCESS;
}

