#include <systemc.h>
#include <signal.h>
#include <iostream>
#include <fstream>

#include "test.h"

#define ASSERT(x) \
  { \
    if (!(x)) \
    { \
    cerr << "ASSERT : '" #x "' at cycle number " << sc_simulation_time () << "\n"; \
    exit (1); \
    } \
  }

using namespace std;
	

int sc_main (int argc, char *argv[])
{
  sc_clock        clk("clk");
  sc_signal<bool> resetn("resetn");
  sc_signal<int>  in ("in");
  sc_signal<int>  out("out");
 
  test test("test");
  test.clk    (clk);
  test.resetn (resetn);

  test.i (in);
  test.o (out);

  sc_initialize ();

  resetn = false;
  sc_start (3);
  resetn = true;
  sc_start (20);

  cout << "Test OK.\n";
	return EXIT_SUCCESS;
}
