#include "systemc.h"

#define ASSERT(x) \
  { errnum++; \
    if (!(x)) \
    { \
    cerr << "ASSERT : " #x "\n"; \
    exit (errnum); \
    } \
  }

using namespace std;

struct hard : sc_module
{
  sc_in_clk        clk;
  sc_in<bool>      resetn;
  sc_in <int>      i1;
  sc_out<int>      o1;
  sc_signal <int>  r1;

  void fg ()
  {
    o1 = r1;
  }

  void ft ()
  {
    if (resetn.read())
      r1 = i1;
    else
      r1 = 0x0;
  }

  SC_HAS_PROCESS(hard);
  hard(sc_module_name)
  {
    SC_METHOD(ft);
    dont_initialize();
    sensitive << clk.pos();
    SC_METHOD(fg);
    dont_initialize();
    sensitive << clk.neg();
#ifdef SYSTEMCASS_SPECIFIC
#endif
  }
};

int
sc_main (int argc, char ** argv)
{
  int errnum = 0;
  sc_clock        clk1("clk1", 1, 0.5,0,true);
  sc_signal<bool> resetn;
  sc_signal<int>  s[10];
  hard a("a");

  a.clk    (clk1);
  a.resetn (resetn);

  a.i1 (s[0]);
  a.o1 (s[1]);

 	/* Open trace file */
	sc_trace_file *system_trace_file;
	system_trace_file = sc_create_vcd_trace_file ("trace_file");
	
	/* clks waveforms are always useful */
	sc_trace(system_trace_file, resetn, "resetn");
	sc_trace(system_trace_file, s[0],   "i1");
	sc_trace(system_trace_file, s[1],   "o1");
	sc_trace(system_trace_file, clk1,   "clk1");

  /* initilization */
  sc_initialize ();

  s[0] = 0;
  resetn = 0;

  sc_start (5);

  s[0] = 0x7B;
  resetn = 1;

  sc_start (1);

  for (int i = 0; i < 10; i++)
  {
    s[0] = i;
    sc_start (1);
//    cout << i << " " << s[1].read() << " " << a.o1.read() << endl;
    //ASSERT(((i > 0) && (s[1].read() == i - 1)) || ((i == 0) && (s[1].read() == 0x7B)));
    ASSERT(s[1].read() == i);
  }

  cout << "Test OK\n";
  return 0;
}

