#include "systemc.h"
#include <iostream>

using namespace std;

#define ASSERT(x) \
  { errnum++; \
    if (!(x)) \
    { \
    cerr << "ASSERT : " #x "\n"; \
    exit (errnum); \
    } \
  }

using namespace std;

struct observer : sc_module
{
  sc_in_clk    clk;

  sc_in<int>   i;

  void f ()
  {
#if 0
    cerr << i.read();
#endif
  }

  SC_HAS_PROCESS(observer);
  observer(sc_module_name) : clk ("clk"),
                             i   ("i")

  {
    SC_METHOD(f);
    dont_initialize();
    sensitive << clk.pos();
#ifdef SYSTEMCASS_SPECIFIC
#endif
  }
};

struct generator : sc_module
{
  sc_in_clk    clk;

  sc_out<int>   o;
  sc_in<int>    i;

  void f ()
  {
    int t = (int) (sc_time_stamp ().to_double());
#if 0
    cerr << "f = " << t << endl;
#endif
    o.write(t);
  }

  SC_HAS_PROCESS(generator);
  generator(sc_module_name) : clk ("clk"),
                              o   ("o")
  {
    SC_METHOD(f);
    dont_initialize();
    sensitive << clk.neg() << i;
#ifdef SYSTEMCASS_SPECIFIC
    o(i);
#endif
  }
};

struct top_level : sc_module
{
  sc_in_clk    clk;
  
  sc_out<int>    o;
  sc_in <int>    i;
//  sc_out<int>  io;
//  sc_signal<int> s;
//  sc_signal<int> s2;

  generator g;
  observer  obs1, obs2;
  
  SC_HAS_PROCESS(top_level);
  top_level(sc_module_name) : g   ("generator"), 
                              obs1("observer1"),
                              obs2("observer2"),
                              clk ("clk"),
                              o   ("o"),
                              i   ("i")/*,
                              s   ("s")*/
  {
    g.clk    (clk);
    obs1.clk (clk);
    obs2.clk (clk);

    g.i   (i);
    g.o   (o);
    obs1.i(o);
    obs2.i(o);
 
#ifdef SYSTEMCASS_SPECIFIC
    o     (i); // wrong declaration that needs detection (no sc_method)
#endif
  }
};

int
sc_main (int argc, char ** argv)
{
  int errnum = 0;
  sc_clock       clk("top_clk");
  sc_signal<int> out("top_out");
  sc_signal<int> in ("top_in");

  top_level t("top_level");

  t.clk (clk);
  t.o   (out);
  t.i   (in);

#if 0
 	/* Open trace file */
	sc_trace_file *system_trace_file;
	system_trace_file = sc_create_vcd_trace_file ("trace_file");
	
	/* clks waveforms are always useful */
	sc_trace(system_trace_file, clk1, "clk1");
	sc_trace(system_trace_file, clk2, "clk2");

  /* others signals */ 
  for (int i = 0; i < 10; ++i)
    sc_trace(system_trace_file, s[i], sc_gen_unique_name ("s"));
#endif

  /* initilization */
#if 0 
  cout << "initilization...\n";
#endif
  sc_initialize ();

  /* simulation */
#if 0 
  cout << "simulation...\n";
#endif
  int i = 0;
  while (i++ < 5)
  {
   sc_start (1);
   ASSERT(out.read() == t.obs1.i.read())
   ASSERT(out.read() == t.obs2.i.read())
  }

#if 0 
  cout << "\ndone.\n";  
#endif

  return 0;
}

