#include <systemc.h>

#define ASSERT(x) \
  { \
    if (!(x)) \
    { \
    cerr << "ASSERT : " #x "\n"; \
    exit (1); \
    } \
  }

using namespace std;

struct test : sc_module {
  int                             reg;
  sc_signal<bool>                 reg_bool;
  sc_signal<char>                 reg_char;
  sc_signal<double>               reg_double;
  sc_signal<sc_biguint<64> >      reg_ui64;
  sc_signal<sc_uint<33> >         reg_ui33;
  sc_signal<sc_uint<32> >         reg_ui32;
  sc_signal<sc_uint<16> >         reg_ui16;
  sc_signal<sc_uint<6> >          reg_ui6;
  sc_signal<sc_int<2> >           reg_i2;
 
  sc_in_clk                       clk;
  sc_in<bool>                     resetn;

  void trans ()
  {
    if (resetn.read() == true)
    {
      reg        = reg + 1;
      reg_bool   = reg & 1;
      reg_char   = reg;
      reg_double = reg;
      reg_ui64   = reg;
      reg_ui33   = reg;
      reg_ui32   = reg;
      reg_ui16   = reg;
      reg_ui6    = reg;
      reg_i2     = reg;
    } else {
      reg        = 0;
      reg_bool   = 0;
      reg_char   = 0;
      reg_double = 0;
      reg_ui64   = 0;
      reg_ui33   = 0;
      reg_ui32   = 0;
      reg_ui16   = 0;
      reg_ui6    = 0;
      reg_i2     = 0;
    }
  }

  SC_HAS_PROCESS(test);
	test (sc_module_name n) : sc_module (n),
    clk("clk")
  {
		SC_METHOD(trans);
		sensitive << clk.pos();
    dont_initialize();
	};
};

int sc_main (int argc, char *argv[])
{
	sc_clock        signal_clk("my_clock",1, 0.5);
  sc_signal<bool> resetn("resetn");

  test test1("test1");
  test1.clk    (signal_clk);
  test1.resetn (resetn);

	// Init & run
	sc_start (0);

  resetn = false;
	sc_start (4);
  resetn = true;
  sc_start (100);

	return EXIT_SUCCESS;
}

#undef sc_inout
