#include <systemc.h>
#include <signal.h>
#include "chrono.h"

using namespace std;
	
struct A : sc_module {
	sc_in_clk                       clk;
	sc_out<bool>                    o1;

	void eval () {
    o1 = (rand()%2) == 0;
	}

	SC_CTOR (A) : clk ("clk"), o1("o1") {
		SC_METHOD(eval);
		sensitive << clk.neg();
#ifdef SYSTEMCASS_SPECIFIC
//		s1();
#endif
	};
};

struct B : sc_module {
	sc_in_clk                       clk;
	sc_in<bool>                     i1;
	sc_in<bool>                     i2;
	sc_out<bool>                    o1;
	sc_out<bool>                    o2;

	void eval1 () {
    o1 = ~i1;
	}
	void eval2 () {
    o2 = ~i2;
	}

	SC_CTOR (B) : clk ("clk"), i1 ("i1"), o1("o1"), i2 ("i2"), o2 ("o2") {
		SC_METHOD(eval1);
		sensitive << clk.neg();
		sensitive << i1;
#ifdef SYSTEMCASS_SPECIFIC
		o1(i1);
#endif
		SC_METHOD(eval2);
		sensitive << clk.neg();
		sensitive << i2;
#ifdef SYSTEMCASS_SPECIFIC
		o2(i2);
#endif
	};
};

struct C : sc_module {
	sc_in_clk                       clk;
	sc_in<bool>                     i1;
	sc_in<bool>                     i2;
	sc_out<bool>                    o1;

	void eval1 () {
    o1 = i1 ^ i2;
	}

	SC_CTOR (C) : clk ("clk"), i1 ("i1"), o1("o1"), i2 ("i2") {
		SC_METHOD(eval1);
		sensitive << clk.neg();
		sensitive << i1 << i2;
#ifdef SYSTEMCASS_SPECIFIC
		o1(i1);
		o1(i2);
#endif
	};
};

struct D : sc_module {
	sc_in_clk                       clk;
	sc_out<bool>                    o1;

	void eval () {
    o1 = (rand()%2) == 0;
	}

	SC_CTOR (D) : clk ("clk"), o1("o1") {
		SC_METHOD(eval);
		sensitive << clk.neg();
#ifdef SYSTEMCASS_SPECIFIC
//		s1();
#endif
	};
};

int sc_main (int argc, char *argv[])
{
	sc_clock                     signal_clk("my_clock",1, 0.5);
	sc_signal<bool>              s1("s1"),s2("s2"),s3("s3"),s4("s4"),s5("s5");

	A      a("a");
	B      b("b");
	C      c("c");
	D      d("d");
	
	a.clk         (signal_clk);
	b.clk         (signal_clk);
	c.clk         (signal_clk);
	d.clk         (signal_clk);
	
	a.o1          (s1);
	b.i1          (s1);
		
	d.o1          (s2);
	c.i2          (s2);

	b.o1          (s3);
	c.i1          (s3);
	
	c.o1          (s4);
	b.i2          (s4);
	
	b.o2          (s5);
	
	// Init & run
	sc_initialize ();

  if (argc == 1)
  {
    cout << "Usage :\n" << argv[0] << " [#cycles]\n";
    return EXIT_SUCCESS;
  }

	chrono_t chrono;
	chrono.start ();

  sc_start (atoi(argv[1]));

	chrono.stop ();
	unsigned int t = chrono;
	cout << "Time elapsed (sec) : " << t << endl;
	cout << "Cycles done        : " << sc_simulation_time () << endl;
	cout << "Performance        : " << sc_simulation_time () / t << endl;
	printf("\nPress <RETURN> to exit simulation.");
	char buf_ret[2];
	cin.getline(buf_ret,1);
	return EXIT_SUCCESS;
}
