#include "systemc.h"
#include <iostream>


using namespace std;


int
sc_main (int argc, char ** argv)
{
  int errnum = 0;
 
  sc_uint<32> a;
  sc_uint<3>  b;
  sc_uint<2>  c;
  sc_uint<5>  d;
  sc_uint<8>  e;
  sc_uint<10> f;

  a = 0xCFFFFFFF;
  b = 0x7;
  c = 0x3;
  d = 0xA0;
  e = 0x11;
  f = 0x1A0;
 
  cerr << "a = 0x" << hex << (unsigned int)a << " = " << a.to_string (SC_BIN) << "\n";
  if (a.to_string (SC_BIN) != "0b011001111111111111111111111111111")
    exit (errnum);
  errnum++;

  cerr << "b = 0x" << hex << (unsigned int)b << " = " << b.to_string (SC_BIN) << "\n";
  if (b.to_string (SC_BIN) != "0b0111")
    exit (errnum);
  errnum++;

  cerr << "c = 0x" << hex << (unsigned int)c << " = " << c.to_string (SC_BIN) << "\n";
  if (c.to_string (SC_BIN) != "0b011")
    exit (errnum);
  errnum++;

  cerr << "d = 0x" << hex << (unsigned int)d << " = " << d.to_string (SC_BIN) << "\n";
  if (d.to_string (SC_BIN) != "0b000000")
    exit (errnum);
  errnum++;

  cerr << "e = 0x" << hex << (unsigned int)e << " = " << e.to_string (SC_BIN) << "\n";
  if (e.to_string (SC_BIN) != "0b000010001")
    exit (errnum);
  errnum++;

  cerr << "f = 0x" << hex << (unsigned int)f << " = " << f.to_string (SC_BIN) << "\n";
  if (f.to_string (SC_BIN) != "0b00110100000")
    exit (errnum);
  errnum++;


  cerr << "b,e = 0x" << hex << (unsigned int)(b,e) << " = " << (b,e).to_string (SC_BIN) << "\n";
  if ((b,e).to_string (SC_BIN) != "0b011100010001")
    exit (errnum);
  errnum++;


  cerr << "b,c,d,e,f = 0x" << hex << (unsigned int)(b,c,d,e,f) << " = " << (b,c,d,e,f).to_string (SC_BIN) << "\n";
  if ((b,c,d,e,f).to_string (SC_BIN) != "0b01111100000000100010110100000")
    exit (errnum);
  errnum++;

  a = b,c,d,e,f;
  cerr << "a = b,c,d,e,f; a = 0x" << hex << (unsigned int) a << " = " << a.to_string (SC_BIN) << "\n";
  if (a.to_string (SC_BIN) != "0b000000000000000000000000000000111")
    exit (errnum);
  errnum++;

  sc_uint<3> tb = b.range (2,0);
  cerr << "b.range (2,0) = 0x" << hex << (unsigned int) tb << " = " << tb.to_string (SC_BIN) << "\n";
  if (tb.to_string (SC_BIN) != "0b0111")
    exit (errnum);
  errnum++;

  sc_uint<5> te = e.range (5,1);
  cerr << "e.range (5,1) = 0x" << hex << (unsigned int) te << " = " << te.to_string (SC_BIN) << "\n";
  if (te.to_string (SC_BIN) != "0b001000")
    exit (errnum);
  errnum++;
  
  sc_uint<5> tf = f.range (9,5);
  cerr << "f.range (9,5) = 0x" << hex << (unsigned int) tf << " = " << tf.to_string (SC_BIN) << "\n";
  if (tf.to_string (SC_BIN) != "0b001101")
    exit (errnum);
  errnum++;

  sc_uint<5> tf2 = f.range (8,4);
  a = (tf2,b,c,d,e,f);
  cerr << "a = f.range (7,3),b,c,d,e,f; a = 0x" << hex << (unsigned int) a << " = " << a.to_string (SC_BIN) << "\n";
  if (a.to_string (SC_BIN) != "0b010101111100000000100010110100000")
    exit (errnum);
  errnum++;

  return 0;
}

