#include <systemc.h>

#define ASSERT(x) \
  { \
    if (!(x)) \
    { \
    cerr << "ASSERT : " #x "\n"; \
    exit (1); \
    } \
  }

using namespace std;

struct inner1 : sc_module {
  sc_in_clk                       clk;
  sc_in <int>                     i1;
  sc_out<int>                     o1;

  void mealy ()
  {
    cerr << "executing 'mealy' function at cycle #" << sc_simulation_time ()
         << endl;
    o1 = i1.read() + 3;
  }

  SC_HAS_PROCESS(inner1);
  inner1 (sc_module_name)
  {
    SC_METHOD(mealy);
    sensitive << clk.neg() << i1;
  }
};

struct inner2 : sc_module {
  sc_in_clk                       clk;
  sc_in <bool>                    resetn;
  sc_in <int>                     i1;
  sc_out<int>                     o1;
  sc_signal<int>                  reg1;

  void transition ()
  {
    //reg1 = 0;
    if (resetn.read())
      reg1 = i1.read();
    else
      reg1 = 0;
  }
  void generation ()
  {
    o1  = reg1.read();
  }

  SC_HAS_PROCESS(inner2);
  inner2 (sc_module_name)
  {
    SC_METHOD(transition);
    sensitive << clk.pos();
    SC_METHOD(generation);
    sensitive << clk.neg();
  }
};

struct test : sc_module {
  sc_in_clk       clk;
  sc_in<bool>     resetn;
 
  sc_signal<int>  sig;

  inner1          comp1;
  inner2          comp2;
 
  sc_in <int>                     i1;
  sc_out<int>                     o1;

  SC_HAS_PROCESS(test);
	test (sc_module_name n) : sc_module (n),
    comp1("comp1"),
    comp2("comp2"),
    clk("clk")
  {
    comp1.clk (clk);
    comp1.i1  (i1);
    comp1.o1  (sig);
    comp2.clk (clk);
    comp2.resetn(resetn);
    comp2.i1  (sig);
    comp2.o1  (o1);
	};
};

int sc_main (int argc, char *argv[])
{
	sc_clock        signal_clk("my_clock",1, 0.5);
  sc_signal<bool> resetn("resetn");
  sc_signal<int > s01("s01");
  sc_signal<int > s02("s02");

  test test1("test1");
  test1.clk    (signal_clk);
  test1.resetn (resetn);
  test1.i1     (s01);
  test1.o1     (s02);

	// Init & run
	sc_start (0);

  s01 = 1;
  resetn = false;
	sc_start (4);
  resetn = true;
  sc_start (1);
  ASSERT(s02.read() == 4); 
  sc_start (2);
  ASSERT(s02.read() == 4); 
  s01 = 10;
  sc_start (20);
  ASSERT(s02.read() == 13); 

	return EXIT_SUCCESS;
}

#undef sc_inout
