#include <systemc.h>

#define ASSERT(x) \
  { \
    if (!(x)) \
    { \
    cerr << "ASSERT : " #x "\n"; \
    exit (1); \
    } \
  }

using namespace std;

struct test : sc_module {
  int                             reg;
  sc_signal<bool>                 reg_bool;
  sc_signal<int>                  reg_int;
  sc_signal<unsigned int>         reg_unsigned_int;
  sc_signal<char>                 reg_char;
  sc_signal<double>               reg_double;
  sc_signal<long>                 reg_long;
  sc_signal<sc_uint<32> >         reg_ui32;
  sc_signal<sc_uint<16> >         reg_ui16;
  sc_signal<sc_uint<6> >          reg_ui6;
  sc_signal<sc_int<32> >          reg_i32;
  sc_signal<sc_int<16> >          reg_i16;
  sc_signal<sc_int<6> >           reg_i6;
 
  sc_in_clk                       clk;
  sc_in<bool>                     resetn;

  void trans ()
  {
    if (resetn.read() == true)
    {
      ASSERT(((reg & 1))            == reg_bool  .read());
      ASSERT(((int)   reg)          == reg_int   .read());
      ASSERT(((unsigned int)reg)    == reg_unsigned_int   .read());
      ASSERT(((char)  reg)        == reg_char  .read());
      ASSERT(((double)reg)          == reg_double.read());
      ASSERT(((long)  reg)          == reg_long  .read());
      ASSERT(((unsigned int) reg & 0xFFFFFFFF) == (unsigned int) (reg_ui32 .read()));
      ASSERT(((unsigned int) reg & 0x0000FFFF) == (unsigned int) (reg_ui16 .read()));
#if 0
      cerr << reg_ui6.read() << " " << (reg & 0x0000003F) << endl;
#endif
      ASSERT(((unsigned int) reg & 0x0000003F)  == (unsigned int) (reg_ui6  .read()));
      ASSERT(((signed int) reg & 0xFFFFFFFF) == (signed int) (reg_i32 .read()));
      ASSERT(((signed int) reg & 0x0000FFFF) == (signed int) (reg_i16 .read()));
      ASSERT(((signed int) reg & 0x0000003F)  == (signed int) (reg_i6  .read()));
      reg        = reg + 1;
      reg_bool   = reg & 1;
      reg_int    = reg;
      reg_unsigned_int = reg;
      reg_char   = reg;
      reg_double = reg;
      reg_long   = reg;
      reg_ui32   = reg;
      reg_ui16   = reg;
      reg_ui6    = reg;
      reg_i32    = reg;
      reg_i16    = reg;
      reg_i6     = reg;
    } else {
      reg        = 0;
      reg_bool   = 0;
      reg_int    = 0;
      reg_unsigned_int = 0;
      reg_char   = 0;
      reg_double = 0;
      reg_long   = 0;
      reg_ui32   = 0;
      reg_ui16   = 0;
      reg_ui6    = 0;
      reg_i32    = 0;
      reg_i16    = 0;
      reg_i6     = 0;
    }
  }

  SC_HAS_PROCESS(test);
	test (sc_module_name n) : sc_module (n),
    clk("clk")
  {
		SC_METHOD(trans);
		sensitive << clk.pos();
    dont_initialize();
	};
};

int sc_main (int argc, char *argv[])
{
	sc_clock        signal_clk("my_clock",1, 0.5);
  sc_signal<bool> resetn("resetn");

  test test1("test1");
  test1.clk    (signal_clk);
  test1.resetn (resetn);

	// Init & run
	sc_start (0);

  resetn = false;
	sc_start (4);
  resetn = true;
  sc_start (100);

	return EXIT_SUCCESS;
}

#undef sc_inout
