#ifndef __CHRONO_H__
#define __CHRONO_H__

#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>

struct chrono_t {
	unsigned int sec;
	chrono_t () 
	{
		sec = 0;
	}
	void start () 
	{
		struct rusage usage;
		getrusage(RUSAGE_SELF, &usage);
		sec = usage.ru_utime.tv_sec;
	}
	void cont () 
	{
		struct rusage usage;
		getrusage(RUSAGE_SELF, &usage);
		sec = usage.ru_utime.tv_sec - sec;
	}
	void stop ()
	{
		cont ();
	}
	operator unsigned int () const
	{ return sec; }	
	friend std::ostream& operator << (std::ostream& o, const chrono_t &c)
	{
		return o << c.sec << "sec";
	}
};

#endif

