/*------------------------------------------------------------\
|                                                             |
| Tool    :                  systemcass                       |
|                                                             |
| File    :                   sc_pat_trace.cc                 |
|                                                             |
| Author  :                 Kingbo Paul-Jerome                |
|                           Buchmann Richard                  |
|                                                             |
| Date    :                   09_07_2004                      |
|                                                             |
\------------------------------------------------------------*/

/* 
 * This file is part of the Disydent Project
 * Copyright (C) Laboratoire LIP6 - Dpartement ASIM
 * Universite Pierre et Marie Curie
 * 
 * Home page          : http://www-asim.lip6.fr/disydent
 * E-mail             : mailto:richard.buchmann@lip6.fr
 * 
 * This library is free software; you  can redistribute it and/or modify it
 * under the terms  of the GNU Library General Public  License as published
 * by the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * Disydent is distributed  in the hope  that it  will be
 * useful, but WITHOUT  ANY WARRANTY; without even the  implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy  of the GNU General Public License along
 * with the GNU C Library; see the  file COPYING. If not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include"sc_trace.h"
#include"sc_pat_trace.h"
#include"sc_ver.h"
#include"internal.h" // notrace

#include<ctime>

#ifdef PAT_TRACE_FORMAT

//-----------------------------------------

extern "C" {
#include "genpat.h"
}

//#include "malloc.h" // NO LONGER SUPPORTED
#include <cstdlib>
#include <cstdio>

//-----------------------------------------

using namespace std;

namespace sc_core {

//*************************************************************************

sc_trace_file*
sc_create_pat_trace_file(const char * name)
{
  if (notrace)
    return NULL;
	//cration d'1 instance de la structure Sc_trace_file:
	sc_trace_file *traceFic=new sc_trace_file();
	traceFic->flag = PAT_FORMAT;	
	
	trace_file_list.push_back(traceFic);
	
	DEF_GENPAT((char *)name);
	
	return traceFic; 
	//pointeur sur le sc_trace_file dontl'un des elts pointe sur le fichier.pat cre 
	
}

//*************************************************************************

void
sc_close_pat_trace_file( sc_trace_file* traceFic )
{	
  if (notrace)
    return;

  trace  (*traceFic,false);

	SAV_GENPAT ();
	
	//libration de l'instance de la structure en mmoire:
	delete traceFic;

	vector<sc_trace_file*>::iterator i;
	for (i = trace_file_list.begin (); i != trace_file_list.end(); ++i)
		if (*i == traceFic) {
			trace_file_list.erase(i);
			break;
		}
}

} // end of sc_core namespace

#endif
