#include "systemc.h"
#include <iostream>
#include <cstring>

#define ASSERT(x) \
  { errnum++; \
    if (!(x)) \
    { \
    cerr << "ASSERT : " #x "\n"; \
    exit (errnum); \
    } \
  }

#ifdef DEBUG
#define CERR(x) \
  { cerr << "" #x " = " << x << "\n"; }
#else
#define CERR(x)
#endif


using namespace std;

static int errnum = 0;

void
check_time (int i)
{
	const sc_time &t = sc_time_stamp ();
  CERR(i);
  CERR(t.to_double());
  ASSERT((int) (t.to_double ()) == i * 1000);
  CERR(t.to_seconds ());
	double seconds = t.to_seconds()*1000000000;
  CERR(seconds);
  ASSERT(((int)seconds) == i);
  char s[256];
  const char *unit;
  if (i == 0)
    unit = "s";
  else if (i < 1000)
    unit = "ns";
  else
    unit = "ns";
  sprintf (s, "%d %s", i,unit);
  CERR(s);
  CERR(t.to_string());
  ASSERT(strcmp (t.to_string ().c_str(), s)== 0); 
}

int
sc_main (int argc, char ** argv)
{
  sc_clock clk ("clock");

  check_time (0);
	sc_start (0);

  check_time (0);
	sc_start (1);
  check_time (1);

	sc_start (15);
  check_time (16);

	sc_start (7);
  check_time (23);

	sc_start (100);
  check_time (123);

	sc_start (1000);
  check_time (1123);
  cerr << "Test OK.\n";
  return 0;
}

