#include "systemc.h"
#include <iostream>

using namespace std;

#define ASSERT(x) \
  { errnum++; \
    if (!(x)) \
    { \
    cerr << "ASSERT : " #x "\n"; \
    exit (errnum); \
    } \
  }

using namespace std;

#define MASK 0x0000000FFFFFFFFFLLU
typedef sc_uint<36> data_type; 

struct observer : sc_module
{
  sc_in_clk    clk;

  sc_in<data_type>   i;

  void f ()
  {
    cout << "0x" << hex << i.read() << endl;
    data_type t = i.read();
    if (t == 7)
      cout << "(== 0x7)\n";
    t <<= 1;
    if (t == 14)
      cout << "((t << 1) == 0xe)\n";
    t += 1;
    if (t == 15)
      cout << "(((t << 1) + 1) == 0xf)\n";
    t = t >> 1;
    if (t == 7)
      cout << "((((t << 1) + 1) >> 1) == 0x7)\n";
  }

  SC_HAS_PROCESS(observer);
  observer(sc_module_name) : clk ("clk"),
                             i   ("i")

  {
    SC_METHOD(f);
    dont_initialize();
    sensitive << clk.pos();
#ifdef SYSTEMCASS_SPECIFIC
#endif
  }
};

struct generator : sc_module
{
  sc_in_clk    clk;

  sc_out<data_type>   o;
  sc_in<data_type>    i;

  long long int t;

  void f ()
  {
    t <<= 1;
    t++;
#if 0
    cout << "0x" << hex << (MASK & t) << " ; ";
#endif
    o.write(t);
  }

  SC_HAS_PROCESS(generator);
  generator(sc_module_name) : clk ("clk"),
                              o   ("o")
  {
    t = 1;
    SC_METHOD(f);
    dont_initialize();
    sensitive << clk.neg() << i;
#ifdef SYSTEMCASS_SPECIFIC
    o(i);
#endif
  }
};

struct top_level : sc_module
{
  sc_in_clk    clk;
  
  sc_out<data_type>    o;
  sc_in <data_type>    i;
//  sc_out<int>  io;
//  sc_signal<int> s;
//  sc_signal<int> s2;

  generator g;
  observer  obs1, obs2;
  
  SC_HAS_PROCESS(top_level);
  top_level(sc_module_name) : g   ("generator"), 
                              obs1("observer1"),
                              obs2("observer2"),
                              clk ("clk"),
                              o   ("o"),
                              i   ("i")/*,
                              s   ("s")*/
  {
    g.clk    (clk);
    obs1.clk (clk);
    obs2.clk (clk);

    g.i   (i);
    g.o   (o);
    obs1.i(o);
    obs2.i(o);
 
#ifdef SYSTEMCASS_SPECIFIC
    o     (i); // wrong declaration that needs detection (no sc_method)
#endif
  }
};

int
sc_main (int argc, char ** argv)
{
  int errnum = 0;
  sc_clock             clk("top_clk");
  sc_signal<data_type> out("top_out");
  sc_signal<data_type> in ("top_in");

  top_level t("top_level");

  t.clk (clk);
  t.o   (out);
  t.i   (in);

  /* initilization */
  sc_initialize ();

  /* simulation */
  int i = 0;
  while (i++ < 40)
  {
   sc_start (1);
   ASSERT(out.read() == t.obs1.i.read())
   ASSERT(out.read() == t.obs2.i.read())
   ASSERT(out.read() == (t.g.t & MASK) )
  }

  return 0;
}

