/*------------------------------------------------------------\
|                                                             |
| Tool    :                  systemcass                       |
|                                                             |
| File    :                   sc_time.h                       |
|                                                             |
| Author  :                 Buchmann Richard                  |
|                                                             |
| Date    :                   09_07_2004                      |
|                                                             |
\------------------------------------------------------------*/
#ifndef __SC_TIME_H__
#define __SC_TIME_H__

#include <iostream>
#include <string>
#include "sc_nbdefs.h"
#include "internal_ext.h"

namespace sc_core {

// ----------------------------------------------------------------------------
//  ENUM : sc_time_unit
//
//  Enumeration of time units.
// ----------------------------------------------------------------------------

enum sc_time_unit
{
    SC_FS = 0,
    SC_PS,
    SC_NS,
    SC_US,
    SC_MS,
    SC_SEC
};

//
class sc_time;
extern const sc_time SC_ZERO_TIME;
extern sc_time SC_CURRENT_TIME;

extern uint64 nb_cycles;

inline double sc_simulation_time()   // in default time units
{
  return (double)nb_cycles;
}

const sc_time& sc_time_stamp ();

//
class sc_time 
{
  friend const sc_time &sc_time_stamp ();
  long long int time;
public:
//  sc_time (); LRM 2.1
  sc_time (double val, sc_time_unit tu);
  sc_time (const sc_time& = SC_ZERO_TIME);
 
  sc_time& operator= (const sc_time &);
 
  /*sc_dt::*/uint64 value     () const { return (/*sc_dt::*/uint64) time;}
  double        to_double () const { return time * 1000;}
  double        to_seconds() const { return time / (double)1000000000;};
  operator      double    () const { return to_double ();};
  const std::string to_string () const;
};

inline const sc_time& sc_time_stamp ()   // in default time units
{
  SC_CURRENT_TIME.time = nb_cycles;
  return SC_CURRENT_TIME;// = sc_time (nb_cycles, SC_NS);
}

} // end of namespace sc_core

using sc_core::sc_simulation_time;
using sc_core::sc_time;
using sc_core::sc_time_stamp;

#endif /* __SC_TIME_H__ */
