/*------------------------------------------------------------\
|                                                             |
| Tool    :                  systemcass                       |
|                                                             |
| File    :                  dump_dot.cc                      |
|                                                             |
| Author  :                 Buchmann Richard                  |
|                                                             |
| Date    :                   09_07_2004                      |
|                                                             |
\------------------------------------------------------------*/

/* 
 * This file is part of the Disydent Project
 * Copyright (C) Laboratoire LIP6 - Dpartement ASIM
 * Universite Pierre et Marie Curie
 * 
 * Home page          : http://www-asim.lip6.fr/disydent
 * E-mail             : mailto:richard.buchmann@lip6.fr
 * 
 * This library is free software; you  can redistribute it and/or modify it
 * under the terms  of the GNU Library General Public  License as published
 * by the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * Disydent is distributed  in the hope  that it  will be
 * useful, but WITHOUT  ANY WARRANTY; without even the  implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy  of the GNU General Public License along
 * with the GNU C Library; see the  file COPYING. If not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <fstream>
#include "dump_dot.h"
#include "sc_module.h"
#include "sc_port.h"
#include "simplify_string.h"
#include "sc_ver.h" // sc_version

typedef std::list<sc_port_base*> port_list_t;
using namespace std;

namespace sc_core {

// Build a port list owned by the module mod
static void
get_out_port_list (const sc_module &mod, port_list_t &pl)
{
	port2module_t::iterator i;
	for (i = port2module.begin (); i != port2module.end (); ++i) {
		if ((i->second == &mod) && (i->first)) {
			pl.push_back ((sc_port_base*)(i->first));
		}
	}
}

static void
dump_dot (ofstream &o, method_process_t &m)
{
	port_list_t port_list;
	get_out_port_list (*(m.module),port_list);
	port_list_t::iterator op;
	for (op = port_list.begin (); op != port_list.end (); ++op)
  {
		sensitivity_list_t::iterator ip;
		for (ip = m.sensitivity_list.begin(); ip != m.sensitivity_list.end();++ip)
		{	
			if (is_clock (ip->get_interface()))
				continue;
			const char *in = get_name (ip->get_interface().get_pointer());
			const char *out = (*op)->name ();
			string s;
			o << simplify_name(in,s); 
      o << "->";
      o << simplify_name(out,s);
      o << ";\n";
		}		
	}
}

static void
dump_all (ofstream &o, method_process_list_t &lm)
{
	method_process_list_t::iterator it;
	for (it = lm.begin (); it != lm.end (); ++it)
		dump_dot (o,**it);
}

static void
dump_all (ofstream &o, const Vertex & v)
{
  if (v.arcs == NULL)
	  return;
  Arc *a;
  for (a = v.arcs; a; a = a->next)
	{
    method_process_t *m  = (method_process_t*)v.data;
    method_process_t *m2 = (method_process_t*)a->tip->data;
		o << m->module->name ();
	  o << " -> "
		  << m2->module->name () 
      << "\n";
	}
}

static void
dump_all (ofstream &o, Graph &g)
{
	Vertex *v;
  for (v = g.vertices; v < g.vertices + g.n; v++) 
	{
		dump_all (o,*v);
  }
}

bool
SignalDependancyGraph2dot (const char *name, method_process_list_t &lm)
{
	if (!name)
		return false;
	string filename;
	filename =  name;
	filename += ".dot";
	ofstream o;
  o.open (filename.c_str(),ios::out | ios::trunc);
	if (o.is_open () == false)
		return false;
	o << "// Signal dependency graph\n"
             "// Generated by "
          << sc_version () << "\n";
	o << "strict digraph " << name << " {\n";
	dump_all (o,lm);
	o << "}\n";
	o.close ();
	return true;
}



bool
FctDependancyGraph2dot (const char *name, Graph *g)
{
	if (!name)
		return false;
	if (!g)
		return false;
	string filename;
	filename =  name;
	filename += ".dot";
	ofstream o;
  o.open (filename.c_str(),ios::out | ios::trunc);
	if (o.is_open () == false)
		return false;
	o << "// Function dependency graph\n"
             "// Generated by "
          << sc_version () << "\n";
	o << "digraph " << name << " {\n";
	dump_all (o,*g);
	o << "}\n";
	o.close ();
	return true;
}

} // end of sc_core namespace

