/*------------------------------------------------------------\
|                                                             |
| Tool    :                  systemcass                       |
|                                                             |
| File    :                  port_dependancy_ext.h            |
|                                                             |
| Author  :                 Buchmann Richard                  |
|                                                             |
| Date    :                   12_08_2004                      |
|                                                             |
\------------------------------------------------------------*/

/* 
 * This file is part of the Disydent Project
 * Copyright (C) Laboratoire LIP6 - Dpartement ASIM
 * Universite Pierre et Marie Curie
 * 
 * Home page          : http://www-asim.lip6.fr/disydent
 * E-mail             : mailto:richard.buchmann@lip6.fr
 * 
 * This library is free software; you  can redistribute it and/or modify it
 * under the terms  of the GNU Library General Public  License as published
 * by the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * Disydent is distributed  in the hope  that it  will be
 * useful, but WITHOUT  ANY WARRANTY; without even the  implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy  of the GNU General Public License along
 * with the GNU C Library; see the  file COPYING. If not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef PORT_DEPENDENCY_EXT_H
#define PORT_DEPENDENCY_EXT_H

namespace sc_core {

// Declare dependancy
extern void set_port_dependency (const sc_port_base* source,const sc_port_base& destination);

template<typename T, size_t N1, size_t N2>
inline
void
set_port_dependency (sc_in<T>  (&source)[N1],
                     sc_out<T> (&destination)[N2])
{
  int i;
  for (i = 0; i < N1; ++i)
  {
    int j;
    for (j = 0; j < N2; ++j)
    {
      set_port_dependency ((const sc_port_base*) &(source[i]), (const
sc_port_base&) (destination[j]));
    }
  }
}

} // end of namespace

#endif
