/*------------------------------------------------------------\
|                                                             |
| Tool    :                  systemcass                       |
|                                                             |
| File    :                 sc_fwd.h                          |
|                                                             |
| Author  :                 Buchmann Richard                  |
|                                                             |
| Date    :                   09_07_2004                      |
|                                                             |
\------------------------------------------------------------*/
#ifndef __SC_FWD_H__
#define __SC_FWD_H__

#include <vector>
//#include <list>

namespace sc_core {

/////////////////////////////////////////////////
// kernel
//
class method_process_t;
class sc_port_base;
class sc_object;
class sc_interface;
class sc_module;
class sc_event;
class sc_event_finder;
class sc_sensitive;
class sc_sensitive_pos;
class sc_sensitive_neg;
class sc_module_name;
class sc_time;

/////////////////////////////////////////////////
// Ports & Signals
//
template <class T> class sc_in;
template <class T> class sc_inout;
template <class T> class sc_out;
template <class T> class sc_signal;
template < typename T > class sc_port_b;
class sc_signal_base;
class sc_clock;

/////////////////////////////////////////////////
// Tracing
//
class sc_trace_file;

/////////////////////////////////////////////////
// lists
//
typedef std::vector<method_process_t *> method_process_list_t;
}

using sc_core::method_process_t;
using sc_core::sc_port_base;
using sc_core::sc_object;
using sc_core::sc_interface;
using sc_core::sc_module;
using sc_core::sc_module_name;
using sc_core::sc_event;
using sc_core::sc_event_finder;
using sc_core::sc_sensitive;
using sc_core::sc_sensitive_pos;
using sc_core::sc_sensitive_neg;
/////////////////////////////////////////////////
// Ports & Signals
//
using sc_core::sc_time;

using sc_core::sc_in;
using sc_core::sc_inout;
using sc_core::sc_out;
using sc_core::sc_signal;
using sc_core::sc_port_b;
using sc_core::sc_signal_base;
using sc_core::sc_clock;

using sc_core::sc_trace_file;

using sc_core::method_process_list_t;

/////////////////////////////////////////////////
// Data Types
//
namespace sc_dt {

  template <int W> class sc_bigint;
  template <int W> class sc_biguint;
  template <int W> class sc_int;
  template <int W> class sc_uint;
  template <int W> class sc_bv;
  template <int W> class sc_lv;
  class sc_unsigned;
  class sc_signed;
  class sc_bit;
  class sc_logic;
}

using sc_dt::sc_bit;
using sc_dt::sc_bv;
using sc_dt::sc_logic;
using sc_dt::sc_lv;
using sc_dt::sc_unsigned;
using sc_dt::sc_signed;
//using sc_dt::sc_int_base;
using sc_dt::sc_int;
using sc_dt::sc_uint;
using sc_dt::sc_bigint;
using sc_dt::sc_biguint;
//using sc_dt::sc_uint_base;

#endif

