#include <systemc.h>
#include <iostream>


using namespace std;


int
sc_main (int argc, char ** argv)
{
  int errnum = 0;
 
  sc_uint<17> a;
  sc_uint<3>  b;
  sc_uint<2>  c1;
  sc_uint<2>  c2;
  sc_uint<5>  d;
  sc_uint<7>  e;
  sc_uint<1>  f;
  sc_uint<16> g;
  sc_uint<8>  h;

  b  = 0x7;
  c1 = 0x3;
  c2 = 0x1;
  d  = 0xA0;
  e  = 0x11;
  g  = 0xabcd;

  // bit vector concatenation and boolean concatenation
  a = (b,
       (c1 | c2),
       d & (b,c1),
       e);
  
  f = b.range (0,0);

  h = g.range (11,4);

  errnum++;
  cerr << "a = 0x" << hex << (unsigned int)a << " = " << a.to_string (SC_BIN) << "\n";
  if (a.to_string (SC_BIN) != "0b000000111100010001")
  {
    exit (errnum);
  }

  errnum++;
  cerr << "f = 0x" << hex << (unsigned int)f << " = " << f.to_string (SC_BIN) << "\n";
  if (f.to_string (SC_BIN) != "0b01")
  {
    exit (errnum);
  }

  errnum++;
  cerr << "h = 0x" << hex << (unsigned int)h << " = " << h.to_string (SC_BIN) << "\n";
  if (h.to_string (SC_BIN) != "0b010111100")
  {
    exit (errnum);
  }

  cerr << "Test OK.\n";
  return 0;
}

