#TARGET_ARCH  		=Linux.SLA4x
#TARGET_ARCH  		= linux
#TARGET_PLATFORM  =i386

ifeq (${TARGET_ARCH},Darwin)
DYNAMICLIB_FLAG = -dynamic
ENDIANESS_FLAG  = #-mlittle-endian
else
DYNAMICLIB_FLAG = -rdynamic
ENDIANESS_FLAG  = 
endif
ifndef SYSTEMC
$(error SYSTEMC should be set to SystemC directory (OSCI version) \
to compare simulation results.)
endif

#BFD_LIBERTY     = -lbfd -liberty
#SYSTEMC         = /users/outil/systemc/systemc-2.0.1
#SYSTEMC         = /dsk/l1/misc/richard/systemc_2_1.oct_12_2004.beta
#SYSTEMCASS      = /users/cao/buchmann/systemcass/systemcass
SYSTEMC_INC     = $(SYSTEMC)/include
SYSTEMCASS_INC  = $(SYSTEMCASS)/include
SYSTEMC_LIB     = $(SYSTEMC)/lib-${TARGET_PLATFORM}-${TARGET_ARCH}/libsystemc.a
SYSTEMCASS_LIB  = $(SYSTEMCASS)/lib/libsystemc_$(firstword $(CXX))-d.a
#CXX         		= g++
#CXX          		= icc -w1
CPPFILT     		= c++filt
DEBUG           = -g -DDEBUG
#OPT             = -O2
#PROF        = -pg # gcc
#PROF        = -qp # icc
#EFENCE      = /users/cao/viaud/bin/lib/libefence.a -lpthread
CFLAGS      = $(PROF) $(DEBUG) $(OPT) \
              -UENABLE_TRACE -UENABLE_PAT -I. \
              ${ENDIANESS_FLAG}

LFLAGS      = $(PROF) $(BFD_LIBERTY) -ldl

CFLAGS_SYSTEMC    = $(CFLAGS) \
                    -I$(SYSTEMC_INC) \

CFLAGS_SYSTEMCASS = $(CFLAGS) \
                    -I$(SYSTEMCASS_INC) \
                    ${DYNAMICLIB_FLAG} #-Wno-deprecated

LFLAGS_SYSTEMC    = $(LFLAGS) \
                    $(SYSTEMC_LIB)

LFLAGS_SYSTEMCASS = $(LFLAGS) \
                    ${DYNAMICLIB_FLAG} $(SYSTEMCASS_LIB) ${EFENCE}

#ifndef TARGET_PLATFORM
#$(error TARGET_PLATFORM is not defined.)
#endif
#ifndef TARGET_ARCH
#$(error TARGET_ARCH is not defined.)
#endif
ifndef SYSTEMC
$(error SYSTEMC is not defined.)
endif
ifndef SYSTEMCASS
$(error SYSTEMCASS is not defined.)
endif
ifndef SOCVIEW
$(error SOCVIEW is not defined.)
endif

failcom   = 'exit 1'

