#include <systemc.h>

#define ASSERT(x) \
  { \
    if (!(x)) \
    { \
    cerr << "ASSERT : " #x "\n"; \
    exit (1); \
    } \
  }

using namespace std;

struct test : sc_module {
  sc_signal<int>                  reg;
 
  sc_in_clk                       clk;
  sc_in<bool>                     resetn;
  
  sc_out<int>                     o1;
  sc_out<bool>                    o2;

  void trans ()
  {
    if (resetn.read() == true)
    {
      reg        = reg + 1;
    } else {
      reg        = 0;
    }
    reg = 2;
  }

  void gen ()
  {
    o1 = reg;
    o2 = reg & 1;
  }

  SC_HAS_PROCESS(test);
	test (sc_module_name n) : sc_module (n),
    clk("clk")
  {
		SC_METHOD(trans);
		sensitive << clk.pos();
    dont_initialize();
		SC_METHOD(gen);
		sensitive << clk.neg();
    dont_initialize();
	};
};

int sc_main (int argc, char *argv[])
{
	sc_clock        signal_clk("my_clock",1, 0.5);
  sc_signal<bool> resetn("resetn");
  sc_signal<int > s01("s01");
  sc_signal<bool> s02("s02");

  test test1("test1");
  test1.clk    (signal_clk);
  test1.resetn (resetn);
  test1.o1     (s01);
  test1.o2     (s02);

	// Init & run
	sc_start (0);

  resetn = false;
	sc_start (4);
  resetn = true;
  sc_start (100);

	return EXIT_SUCCESS;
}

#undef sc_inout
