#include <systemc.h>
#include <signal.h>
#include <iostream>
#include <fstream>

#define ASSERT(x) \
  { \
    if (!(x)) \
    { \
    cerr << "ASSERT : '" #x "' at cycle number " << sc_simulation_time () << "\n"; \
    exit (1); \
    } \
  }

using namespace std;

struct inner_test : public sc_module
{
  virtual void transition ()
  {
    cout << "This function is a virtual one.\n";
  };
  inner_test(sc_module_name n)
  {
  };
};

struct test : public inner_test
{
  sc_in<bool>     clk;
  sc_in<bool>     resetn;
  sc_out<int>     o;
  sc_in <int>     i;
  sc_signal<int>  reg;

  void transition ();
  void gen_moore  ();
  void gen_mealy  ();

  SC_HAS_PROCESS(test);
  test(sc_module_name n) : inner_test (n)
  {
    SC_METHOD(transition);
    sensitive << clk.pos();
    SC_METHOD(gen_moore);
    sensitive << clk.neg();
    SC_METHOD(gen_mealy);
    sensitive << clk.neg() << i;
  }
};

void test::transition ()
{
  std::cout << "transition\n";
}

void test::gen_moore ()
{
  std::cout << "gen_moore\n";
}

void test::gen_mealy ()
{
  std::cout << "gen_mealy\n";
}



int sc_main (int argc, char *argv[])
{
  sc_clock        clk("clk");
  sc_signal<bool> resetn("resetn");
  sc_signal<int>  in ("in");
  sc_signal<int>  out("out");
 
  test test("test");
  test.clk    (clk);
  test.resetn (resetn);

  test.i (in);
  test.o (out);

  sc_initialize ();

  resetn = false;
  sc_start (3);
  resetn = true;
  sc_start (10);

  cout << "Test OK.\n";
	return EXIT_SUCCESS;
}
