#include <systemc.h>
#include <signal.h>

using namespace std;
  
struct A : sc_module {
  sc_in_clk                       clk;
  sc_in     <int>                 i1;
  sc_signal <int>                 r1;
  sc_out    <int>                 o1;

  void transition () {
    int i;
    for (i = 0; i < 1000; ++i)
      ;
    r1 = i1;
  }
  void gen_moore () {
    int i;
    for (i = 0; i < 1000; ++i)
      ;
    o1 = r1;
  }

  SC_CTOR (A) : clk ("clk"), o1("o1") {
    SC_METHOD(transition);
    sensitive << clk.pos();
    SC_METHOD(gen_moore);
    sensitive << clk.neg();
  };
};

int sc_main (int argc, char *argv[])
{
  sc_clock                     signal_clk("my_clock",1, 0.5);
  sc_signal<int>               s1("s1"),s2("s2"),s3("s3"),s4("s4");

  A      a("a");
  A      b("b");
  
  a.clk         (signal_clk);
  b.clk         (signal_clk);
  
  a.i1          (s1);
  a.o1          (s2);

  b.i1          (s3);
  b.o1          (s4);

  // Init & run
  sc_initialize ();

  if (argc == 1)
  {
    cout << "Usage :\n" << argv[0] << " [#cycles]\n";
    return EXIT_SUCCESS;
  }

  s1.write (1);

  sc_start (atoi(argv[1]));

  cout << s1.read() << endl;
  cout << s2.read() << endl;

  return EXIT_SUCCESS;
}
