#include "systemc.h"
#include <iostream>

using namespace std;

#define ASSERT(x) \
  { errnum++; \
    if (!(x)) \
    { \
    cerr << "ASSERT : " #x "\n"; \
    exit (errnum); \
    } \
  }

using namespace std;

typedef sc_uint<36> data_type; 

class param_t
{
public:
  static const unsigned int B = 36;
  typedef sc_dt::sc_uint<B> be_t;
};

template <typename param_t>
class test_t 
{
public:
  typedef typename param_t::be_t test_be_t;
  
  test_be_t test_be;
};

int
sc_main (int argc, char ** argv)
{
  sc_uint<36> a;
  const long long int ca = 0xf00000000LLU;
  a = ca;

  test_t<param_t> test1, test2;
  test1.test_be = a;
  test2.test_be = ca;

  if (test1.test_be != test2.test_be)
    return 1;

  bool ret = (test1.test_be == a);
  if (!ret)
    return 1;

  return 0;

  /* the following should be compiled and not executed */
  sc_signal<test_t<param_t>::test_be_t > sig_test;
  sig_test = test1.test_be;

  ret = (sig_test.read() == test2.test_be); /* OK */
  //ret = (sig_test == test2.test_be); /* should be OK but it is not */
  if (!ret)
    return 1;

  return 0;
}

