/*------------------------------------------------------------\
|                                                             |
| Tool    :                  systemcass                       |
|                                                             |
| File    :                  signal_dependancy.h              |
|                                                             |
| Author  :                 Buchmann Richard                  |
|                                                             |
| Date    :                   09_07_2004                      |
|                                                             |
\------------------------------------------------------------*/
#ifndef SIGNAL_DEPENDENCY_H
#define SIGNAL_DEPENDENCY_H

#include <set>
#include "sc_fwd.h"
#include "entity.h" // equi_t
#include "graph.h"
//#include "sc_port.h"
#include "port_dependency.h"

namespace sc_core {

// Signal Dependency Graph
struct SignalDependency {
	const method_process_t *method;
	const equi_t           *source;
	const equi_t           *destination;
	bool operator < (const SignalDependency &a) const;
//	friend int operator < (const SignalDependency &a, const SignalDependency &b);
};

typedef std::set<SignalDependency> SignalDependencyGraph;

// Convert Port Dependency Graph to Signal Dependency Graph
extern SignalDependencyGraph* MakeSignalDependencyGraph (const PortDependencyGraph& = get_port_dependency_graph ());

// Checking
extern bool Check (const SignalDependencyGraph&);
extern bool Check (const method_process_list_t&, const SignalDependencyGraph&);

// Dump
extern bool SignalDependencyGraph2dot (const char *name, const SignalDependencyGraph&);
extern bool SignalDependencyOrder2txt (const char *name, const strong_component_list_t&);

} // end of sc_core namespace

#endif

