// CODE FROM WIKIPEDIA

#define LITTLE_ENDIAN 0
#define BIG_ENDIAN    1

int machineEndianness()
{
   int i = 1;
   char *p = (char *) &i;
   if (p[0] == 1) // Lowest address contains the least significant byte
      return LITTLE_ENDIAN;
   else
      return BIG_ENDIAN;
}

#include <stdio.h>

int
main (int argc, char** argv)
{
  printf ("#define ");
  switch (machineEndianness()) {
  case LITTLE_ENDIAN : 
    printf ("little_endian\n");
    break;
  case BIG_ENDIAN : 
    printf ("big_endian\n");
    break;
  default:
    printf ("unknown_endian\n");
    break;
  }
  return 0;
}

