
#ifndef _variable_hpp_
#define _variable_hpp_

#include "assert.h"

class Variable {

   int proc; // processor to which the variable belongs, -1 if public (most common case)
   int operation; // 0 : RW ; 1 : RO ; 2 : WO
   bool uncached; // Requests on this variable are done uncached
   bool in_trans_line; // if private variable, specifies whether the variable is located in a line containing transactional variables

   public:

   Variable(int proc, int operation, bool uncached, bool in_trans_line = true){
      assert(proc >= -1);
      assert(operation == 0 || operation == 1 || operation == 2);
      assert(in_trans_line || proc != -1);
      this->proc = proc;
      this->operation = operation;
      this->uncached = uncached;
      this-> in_trans_line = in_trans_line;
   }

   Variable(){
      this->proc = -1;
      this->operation = 0;
      this->uncached = false;
      this->in_trans_line = true;
   }

   int getProc(){
      return proc;
   }

   bool isRW(){
      return (operation == 0);
   }

   bool isRO(){
      return (operation == 1);
   }

   bool isWO(){
      return (operation == 2);
   }

   bool isUnc(){
      return uncached;
   }

   void setRO(){
      operation = 1;
   }

   void setWO(){
      operation = 2;
   }

   void setROorWO(){
      int n = randint(1,2);
      if (n == 1){
         operation = 1;
      }
      else {
         operation = 2;
      }
   }

   void setPrivate(int proc_id){
      proc = proc_id;
   }

   void setUncached(){
      uncached = true;
   }

   bool isPublic(){
      return (proc == -1);
   }

   bool isPrivate(int proc_id){
      return (proc == proc_id);
   }

};

#endif
