
#ifndef _increment_hpp_
#define _increment_hpp_

#include "functions.h"
#include "EnsembleVariables.hpp"

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <sstream>

using namespace std;

class Increment {
   int var_index;
   int nb_diff_CL;
   int cache_lines;
   int line_size;
   int proc_id;
   EnsembleVariables * E;

   public:

   Increment(int nb_diff_ML, int nb_diff_CL, int line_size, int cache_lines, EnsembleVariables * E, int proc_id) {
      this->nb_diff_CL = nb_diff_CL;
      this->line_size = line_size;
      this->cache_lines = cache_lines;
      this->E = E;
      this->proc_id = proc_id;

      const int nb_vars_proc = E->getVarCount(proc_id);
      int local_index = randint(0, nb_vars_proc - 1);
      var_index = 0;
      while (!E->isPublic(var_index) && !E->isPrivate(var_index,proc_id)) {
         var_index++;
      }
      for (int i = 0; i < local_index; i++) {
         var_index++;
         while (!E->isPublic(var_index) && !E->isPrivate(var_index,proc_id)) {
            var_index++;
         }
      }
   }

   ~Increment() {}

   string writeOutput() {
      stringstream res;
      int index = index2realindex(var_index, nb_diff_CL, cache_lines, line_size);
      if (E->isPublic(var_index)) {
         if (!E->isUnc(var_index)) {
            if (E->isRW(var_index)) {
               res << "   pthread_spin_lock(&lock_tab[" << var_index << "]);" << endl;
               res << "   tab[" << index << "]++;" << endl;
               res << "   pthread_spin_unlock(&lock_tab[" << var_index << "]);" << endl;
            }
            else if (E->isRO(var_index)) {
               res << "   local_var = tab[" << index << "];" << endl;
            }
            else {
               assert(E->isWO(var_index));
               res << "   tab[" << index << "] = 1;" << endl;
            }
         }
         else {
            if (E->isRW(var_index)) {
               res << "   rd_wr_unc(" << index << ");" << endl;
            }
            else if (E->isRO(var_index)) {
               res << "   rd_unc(" << index << ");" << endl;
            }
            else {
               assert(E->isWO(var_index));
               res << "   wr_unc(" << index << ");" << endl;
            }
         }
      }
      else {
         assert(E->isPrivate(var_index,proc_id));
         if (!E->isUnc(var_index)) {
            if (E->isRW(var_index)) {
               res << "   tab[" << index << "]++; // variable privee au proc " << proc_id << endl;
            }
            else if (E->isRO(var_index)) {
               res << "   local_var = tab[" << index << "]; // variable privee au proc " << proc_id << " et en RO" << endl;
            }
            else {
               assert(E->isWO(var_index));
               res << "   tab[" << index << "] = 1; // variable privee au proc " << proc_id << " et en WO" << endl;
            }
         }
         else {
            if (E->isRW(var_index)) {
               res << "   // Variable privee au proc " << proc_id << endl;
               res << "   rd_wr_unc(" << index << ");" << endl;
            }
            else if (E->isRO(var_index)) {
               res << "   // Variable privee au proc " << proc_id << " et en RO" << endl;
               res << "   rd_unc(" << index << ");" << endl;
            }
            else {
               assert(E->isWO(var_index));
               res << "   // Variable privee au proc " << proc_id << " et en WO" << endl;
               res << "   wr_unc(" << index << ");" << endl;
            }
         }
      }
      return res.str();
   }

};

#endif

