

#include "Program.hpp"
#include "config.h"

#include <time.h>
#include <stdlib.h>
#include <iostream>

int main(int argc, char** argv){

   if (argc != 9){
      printf("usage: genere_test <nb_procs> <nb_max_incr> <nb_max_trans> <nb_diff_ML> <nb_diff_CL> <line_size> <nb_cache_lines> <out_filename>\n");
      exit(1);
   }

   srand(time(NULL));

   FILE * outfile;

   const int nb_procs = atoi(argv[1]);
   const int nb_max_incr = atoi(argv[2]);
   const int nb_max_trans = atoi(argv[3]);
   const int nb_diff_ML = atoi(argv[4]);
   const int nb_diff_CL = atoi(argv[5]);
   const int line_size = atoi(argv[6]);
   const int nb_cache_lines = atoi(argv[7]);

   outfile = fopen(argv[8], "w");

   Program prog(nb_procs, nb_diff_ML, nb_diff_CL, nb_max_trans, nb_max_incr, line_size, nb_cache_lines);

   string s = prog.writeOutput();
   fprintf(outfile, "%s", s.c_str());
   fclose(outfile);

   return 0;
}

