
#ifndef _testthread_hpp_
#define _testthread_hpp_

#include "Transaction.hpp"
#include "EnsembleVariables.hpp"

#include <iostream>
#include <list>

using namespace std;

class TestThread {

   std::list<Transaction*> requests;

   public:

   TestThread(int nb_diff_ML, int nb_diff_CL, int nb_max_trans, int nb_max_insts, int line_size, int cache_lines, EnsembleVariables * E, int proc_id) {
      const int nb_trans = randint(1,nb_max_trans);
      for (int i = 0; i < nb_trans; i++){
         Transaction *t;
         t = new Transaction(nb_diff_ML,nb_diff_CL,nb_max_insts,line_size,cache_lines,E,proc_id);
         requests.push_back(t);
      }
   }

   ~TestThread() {
      std::list<Transaction*>::iterator it;
      for (it = requests.begin(); it != requests.end(); it++) {
         delete (*it);
      }
      requests.clear();
   }

   string writeOutput(int i) {
      stringstream res;
      res << "void run" << i << "() {" << endl;
      res << "   int local_var; // variable pour pouvoir avoir des transactions où l'on ne fait que lire les variables utiles" << endl;
      res << endl;

      std::list<Transaction*>::iterator it;
      for (it = requests.begin(); it != requests.end(); it++) {
         res << (*it)->writeOutput();
      }

      res << "}" << endl;
      res << endl;
      return res.str();
   }

};

#endif
