
#ifndef _transaction_hpp_
#define _transaction_hpp_

#include "Increment.hpp"
#include "EnsembleVariables.hpp"

#include <iostream>
#include <list>
#include <set>

using namespace std;

class Transaction {

   EnsembleVariables * E;
   int proc_id;
   std::list<Increment*> requests;

   public:

   Transaction(int nb_diff_ML, int nb_diff_CL, int nb_max_insts, int line_size, int cache_lines, EnsembleVariables * E, int proc_id){
      this->proc_id = proc_id;
      this->E = E;
      const int nb_insts = randint(1, nb_max_insts);
      for (int i = 0; i < nb_insts; i++) {
         Increment *incr;
         incr = new Increment(nb_diff_ML, nb_diff_CL, line_size, cache_lines, E, proc_id);
         requests.push_back(incr);
      }
   }

   ~Transaction() {
      std::list<Increment*>::iterator it;
      for (it = requests.begin(); it != requests.end(); it++){
         delete (*it);
      }
      requests.clear();
   }

   string writeOutput() {
      stringstream res;
      res << E->writePrivateAccesses(proc_id);
      res << "   // Debut Transaction" << endl;

      std::list<Increment*>::iterator it;
      for (it = requests.begin(); it != requests.end(); it++) {
         res << (*it)->writeOutput();
      }

      res << "   // Fin Transaction" << endl;
      res << endl;

      return res.str();
   }

};

#endif
