/*
 * \file    : reset_utils.h
 * \date    : August 2012
 * \author  : Cesar Fuguet
 */

#ifndef BOOT_UTILS_H
#define BOOT_UTILS_H

#include <elf-types.h>
#include <reset_tty.h>
#include <reset_ioc.h>
#include <defs.h>
#include <mcc.h>
#include <io.h>

/********************************************************************
 * Integer types definition
 ********************************************************************/
typedef unsigned int size_t;
typedef unsigned int addr_t;

/********************************************************************
 * Other types definition
 ********************************************************************/

/*
 * cache line aligned disk block (sector) buffer 
 */
struct aligned_blk
{
    char b[BLOCK_SIZE];
} __attribute__((aligned(CACHE_LINE_SIZE)));

/********************************************************************
 * Utility functions definition
 ********************************************************************/

extern unsigned int proctime();

extern int pread(size_t file_offset, void *buf, size_t nbyte, size_t offset);

extern void* memcpy(void *_dst, const void *_src, size_t n);
extern void* memset(void *_dst, int c, size_t len);

extern void check_elf_header(Elf32_Ehdr *ehdr);
extern void reset_print_elf_phdr(Elf32_Phdr * elf_phdr_ptr);

#if USE_IOB
void reset_mcc_invalidate (const void * buf, size_t size);
#endif /* USE_IOB */

#if (CACHE_COHERENCE == 0) || USE_IOB
void reset_buf_invalidate (const void * buf, size_t line_size, size_t size);
#endif /* (CACHE_COHERENCE == 0) || USE_IOB */
#endif /* BOOT_UTILS_H */

// vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab

