/* -*- c++ -*-
 *
 * SOCLIB_LGPL_HEADER_BEGIN
 *
 * This file is part of SoCLib, GNU LGPLv2.1.
 *
 * SoCLib is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; version 2.1 of the License.
 *
 * SoCLib is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with SoCLib; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 * SOCLIB_LGPL_HEADER_END
 *
 * Authors  : Cesar Armando Fuguet Tortolero
 * Date     : jul 2015
 * Copyright: UPMC - LIP6
 */
#ifndef SYNTHETIC_DSPIN_NETWORK
#define SYNTHETIC_DSPIN_NETWORK

#include <systemc>
#include <stdint.h>
#include "caba_base_module.h"
#include "dspin_router.h"

#if UNICAST
#include "dspin_packet_generator.h"
#else
#include "dspin_broadcast_generator.h"
#endif

namespace soclib {
namespace caba {


class SyntheticDspinNetwork
    : public soclib::caba::BaseModule
{
    static const int X_WIDTH = 4;
    static const int Y_WIDTH = 4;
    static const int DSPIN_WIDTH = 39;
    static const int DSPIN_ROUTER_FIFO_DEPTH = 4;
    static const int DSPIN_GENERATOR_FIFO_DEPTH = 50;

#if UNICAST
    typedef DspinPacketGenerator<DSPIN_WIDTH, DSPIN_WIDTH>
    DspinNetworkGenerator;
#else
    typedef DspinBroadcastGenerator<DSPIN_WIDTH, DSPIN_WIDTH>
    DspinNetworkGenerator;
#endif

    typedef DspinRouter<DSPIN_WIDTH>
    DspinNetworkRouter;
    typedef DspinSignals<DSPIN_WIDTH>
    DspinNetworkSignal;


public:

    sc_core::sc_in<bool> p_clk;
    sc_core::sc_in<bool> p_resetn;

    SyntheticDspinNetwork(sc_module_name name,
                          const size_t x_size,
                          const size_t y_size,
                          const size_t load);

    ~SyntheticDspinNetwork();

    void reset();
    void set_faulty_router(const size_t faulty_x, const size_t faulty_y);
    void print_stats(const size_t x, const size_t y);


private:

    const size_t m_x_size;
    const size_t m_y_size;

    DspinNetworkGenerator **dspinGenerator;
    DspinNetworkRouter **dspinRouter;

    DspinNetworkSignal ***sL;
    DspinNetworkSignal ***sH;
    DspinNetworkSignal ***sV;

    sc_core::sc_signal<uint32_t>** sConfigRouter;
};                  // end class SyntheticDspinNetwork


}                   // end namespace caba
}                   // end namespace soclib

#endif              // end SYNTHETIC_DSPIN_NETWORK

// Local Variables:
// tab-width: 4
// c-basic-offset: 4
// c-file-offsets:((innamespace . 0)(inline-open . 0))
// indent-tabs-mode: nil
// End:
