#include "stdio.h"
#include "cpu.h"
#include "hard_config.h"
#include "io.h"
#include "simhelper.h"
#include "cpu_registers.h"
#include "xcu.h"
#include "soclib/dspin_router_config.h"
#include "assert.h"

void exception_handler()
{
    printf("exception_handler(): failure / pid %d\n", cpu_procid());
    simh_stop_simulation();
}

void main(void)
{
    printf("main(): pid %d\n", cpu_procid());

    /*
     * set the watchdog timer threshold to detect an error during
     * the reconfiguration of the NoC
     */
    cpu_set_wdt_max(1000);

    /*
     * configure the routers around the blackhole (1, 1) to define a cycle-free
     * contour
     */
    printf("router(0, 2): configuring as NW\n");
    assert(xcu_get_register(0, 2, XICU_CFG_REG, 0) == BH_NONE);
    xcu_set_register(0, 2, XICU_CFG_REG, 0, BH_NW);    /* configure NW */

    printf("router(0, 1): configuring as W\n");
    assert(xcu_get_register(0, 1, XICU_CFG_REG, 0) == BH_NONE);
    xcu_set_register(0, 1, XICU_CFG_REG, 0, BH_W);     /* configure W */

    printf("router(0, 0): configuring as SW\n");
    assert(xcu_get_register(0, 0, XICU_CFG_REG, 0) == BH_NONE);
    xcu_set_register(0, 0, XICU_CFG_REG, 0, BH_SW);    /* configure SW */

    printf("router(1, 2): configuring as N\n");
    assert(xcu_get_register(1, 2, XICU_CFG_REG, 0) == BH_NONE);
    xcu_set_register(1, 2, XICU_CFG_REG, 0, BH_N);     /* configure N */

    printf("router(2, 2): configuring as NE\n");
    assert(xcu_get_register(2, 2, XICU_CFG_REG, 0) == BH_NONE);
    xcu_set_register(2, 2, XICU_CFG_REG, 0, BH_NE);    /* configure NE */

    printf("router(2, 1): configuring as E\n");
    assert(xcu_get_register(2, 1, XICU_CFG_REG, 0) == BH_NONE);
    xcu_set_register(2, 1, XICU_CFG_REG, 0, BH_E);     /* configure E */

    printf("router(2, 0): configuring as SE\n");
    assert(xcu_get_register(2, 0, XICU_CFG_REG, 0) == BH_NONE);
    xcu_set_register(2, 0, XICU_CFG_REG, 0, BH_SE);    /* configure SE */

    printf("router(1, 0): configuring as S\n");
    assert(xcu_get_register(1, 0, XICU_CFG_REG, 0) == BH_NONE);
    xcu_set_register(1, 0, XICU_CFG_REG, 0, BH_S);     /* configure S */

    assert(xcu_get_register(0, 2, XICU_CFG_REG, 0) == BH_NW);
    assert(xcu_get_register(0, 1, XICU_CFG_REG, 0) == BH_W);
    assert(xcu_get_register(0, 0, XICU_CFG_REG, 0) == BH_SW);
    assert(xcu_get_register(1, 2, XICU_CFG_REG, 0) == BH_N);
    assert(xcu_get_register(2, 2, XICU_CFG_REG, 0) == BH_NE);
    assert(xcu_get_register(2, 1, XICU_CFG_REG, 0) == BH_E);
    assert(xcu_get_register(2, 0, XICU_CFG_REG, 0) == BH_SE);
    assert(xcu_get_register(1, 0, XICU_CFG_REG, 0) == BH_S);

#if 0
    /*
     * this should cause a livelock (sending a packet to the blackhole once the
     * cycle-free contour has been defined)
     *
     * why?: the router (0, 0) and the router (0, 1) keep sending the packet
     * between them.
     */
    assert(xcu_get_register(1, 1, XICU_CFG_REG, 0) == BH_NONE);
#endif

    printf("main(): success\n");

    simh_stop_simulation();
}

/*
 * vim: tabstop=4 : softtabstop=4 : shiftwidth=4 : expandtab
 */
